/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.machinelearning.model.GetDataSourceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class GetDataSourceRequestMarshaller
implements Marshaller<Request<GetDataSourceRequest>, GetDataSourceRequest> {
    @Override
    public Request<GetDataSourceRequest> marshall(GetDataSourceRequest getDataSourceRequest) {
        if (getDataSourceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDataSourceRequest> request = new DefaultRequest<GetDataSourceRequest>(getDataSourceRequest, "AmazonMachineLearning");
        String target = "AmazonML_20141212.GetDataSource";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (getDataSourceRequest.getDataSourceId() != null) {
                jsonWriter.key("DataSourceId").value(getDataSourceRequest.getDataSourceId());
            }
            if (getDataSourceRequest.isVerbose() != null) {
                jsonWriter.key("Verbose").value(getDataSourceRequest.isVerbose());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

