/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.organizations.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/DescribeEffectivePolicy"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeEffectivePolicyResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The contents of the effective policy.
     * </p>
     */
    private EffectivePolicy effectivePolicy;

    /**
     * <p>
     * The contents of the effective policy.
     * </p>
     * 
     * @param effectivePolicy
     *        The contents of the effective policy.
     */

    public void setEffectivePolicy(EffectivePolicy effectivePolicy) {
        this.effectivePolicy = effectivePolicy;
    }

    /**
     * <p>
     * The contents of the effective policy.
     * </p>
     * 
     * @return The contents of the effective policy.
     */

    public EffectivePolicy getEffectivePolicy() {
        return this.effectivePolicy;
    }

    /**
     * <p>
     * The contents of the effective policy.
     * </p>
     * 
     * @param effectivePolicy
     *        The contents of the effective policy.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeEffectivePolicyResult withEffectivePolicy(EffectivePolicy effectivePolicy) {
        setEffectivePolicy(effectivePolicy);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEffectivePolicy() != null)
            sb.append("EffectivePolicy: ").append(getEffectivePolicy());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeEffectivePolicyResult == false)
            return false;
        DescribeEffectivePolicyResult other = (DescribeEffectivePolicyResult) obj;
        if (other.getEffectivePolicy() == null ^ this.getEffectivePolicy() == null)
            return false;
        if (other.getEffectivePolicy() != null && other.getEffectivePolicy().equals(this.getEffectivePolicy()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEffectivePolicy() == null) ? 0 : getEffectivePolicy().hashCode());
        return hashCode;
    }

    @Override
    public DescribeEffectivePolicyResult clone() {
        try {
            return (DescribeEffectivePolicyResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
