/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.organizations.model;

import javax.annotation.Generated;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public enum CreateAccountFailureReason {

    ACCOUNT_LIMIT_EXCEEDED("ACCOUNT_LIMIT_EXCEEDED"),
    EMAIL_ALREADY_EXISTS("EMAIL_ALREADY_EXISTS"),
    INVALID_ADDRESS("INVALID_ADDRESS"),
    INVALID_EMAIL("INVALID_EMAIL"),
    CONCURRENT_ACCOUNT_MODIFICATION("CONCURRENT_ACCOUNT_MODIFICATION"),
    INTERNAL_FAILURE("INTERNAL_FAILURE"),
    GOVCLOUD_ACCOUNT_ALREADY_EXISTS("GOVCLOUD_ACCOUNT_ALREADY_EXISTS"),
    MISSING_BUSINESS_VALIDATION("MISSING_BUSINESS_VALIDATION"),
    FAILED_BUSINESS_VALIDATION("FAILED_BUSINESS_VALIDATION"),
    PENDING_BUSINESS_VALIDATION("PENDING_BUSINESS_VALIDATION"),
    INVALID_IDENTITY_FOR_BUSINESS_VALIDATION("INVALID_IDENTITY_FOR_BUSINESS_VALIDATION"),
    UNKNOWN_BUSINESS_VALIDATION("UNKNOWN_BUSINESS_VALIDATION"),
    MISSING_PAYMENT_INSTRUMENT("MISSING_PAYMENT_INSTRUMENT");

    private String value;

    private CreateAccountFailureReason(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return CreateAccountFailureReason corresponding to the value
     *
     * @throws IllegalArgumentException
     *         If the specified value does not map to one of the known values in this enum.
     */
    public static CreateAccountFailureReason fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }

        for (CreateAccountFailureReason enumEntry : CreateAccountFailureReason.values()) {
            if (enumEntry.toString().equals(value)) {
                return enumEntry;
            }
        }

        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }
}
