/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.opsworks.model.DataSource;
import com.amazonaws.util.json.SdkJsonGenerator;

public class DataSourceJsonMarshaller {
    private static DataSourceJsonMarshaller instance;

    public void marshall(DataSource dataSource, SdkJsonGenerator jsonGenerator) {
        if (dataSource == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (dataSource.getType() != null) {
                jsonGenerator.writeFieldName("Type").writeValue(dataSource.getType());
            }
            if (dataSource.getArn() != null) {
                jsonGenerator.writeFieldName("Arn").writeValue(dataSource.getArn());
            }
            if (dataSource.getDatabaseName() != null) {
                jsonGenerator.writeFieldName("DatabaseName").writeValue(dataSource.getDatabaseName());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DataSourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DataSourceJsonMarshaller();
        }
        return instance;
    }
}

