/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.opsworks.model.CreateUserProfileRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateUserProfileRequestMarshaller
implements Marshaller<Request<CreateUserProfileRequest>, CreateUserProfileRequest> {
    public Request<CreateUserProfileRequest> marshall(CreateUserProfileRequest createUserProfileRequest) {
        if (createUserProfileRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createUserProfileRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.CreateUserProfile");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (createUserProfileRequest.getIamUserArn() != null) {
                jsonGenerator.writeFieldName("IamUserArn").writeValue(createUserProfileRequest.getIamUserArn());
            }
            if (createUserProfileRequest.getSshUsername() != null) {
                jsonGenerator.writeFieldName("SshUsername").writeValue(createUserProfileRequest.getSshUsername());
            }
            if (createUserProfileRequest.getSshPublicKey() != null) {
                jsonGenerator.writeFieldName("SshPublicKey").writeValue(createUserProfileRequest.getSshPublicKey());
            }
            if (createUserProfileRequest.getAllowSelfManagement() != null) {
                jsonGenerator.writeFieldName("AllowSelfManagement").writeValue(createUserProfileRequest.getAllowSelfManagement().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

