/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.ElasticLoadBalancer;
import com.amazonaws.util.json.JSONWriter;

public class ElasticLoadBalancerJsonMarshaller {
    private static ElasticLoadBalancerJsonMarshaller instance;

    public void marshall(ElasticLoadBalancer elasticLoadBalancer, JSONWriter jsonWriter) {
        if (elasticLoadBalancer == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList ec2InstanceIdsList;
            SdkInternalList subnetIdsList;
            SdkInternalList availabilityZonesList;
            jsonWriter.object();
            if (elasticLoadBalancer.getElasticLoadBalancerName() != null) {
                jsonWriter.key("ElasticLoadBalancerName").value((Object)elasticLoadBalancer.getElasticLoadBalancerName());
            }
            if (elasticLoadBalancer.getRegion() != null) {
                jsonWriter.key("Region").value((Object)elasticLoadBalancer.getRegion());
            }
            if (elasticLoadBalancer.getDnsName() != null) {
                jsonWriter.key("DnsName").value((Object)elasticLoadBalancer.getDnsName());
            }
            if (elasticLoadBalancer.getStackId() != null) {
                jsonWriter.key("StackId").value((Object)elasticLoadBalancer.getStackId());
            }
            if (elasticLoadBalancer.getLayerId() != null) {
                jsonWriter.key("LayerId").value((Object)elasticLoadBalancer.getLayerId());
            }
            if (elasticLoadBalancer.getVpcId() != null) {
                jsonWriter.key("VpcId").value((Object)elasticLoadBalancer.getVpcId());
            }
            if (!(availabilityZonesList = (SdkInternalList)elasticLoadBalancer.getAvailabilityZones()).isEmpty() || !availabilityZonesList.isAutoConstruct()) {
                jsonWriter.key("AvailabilityZones");
                jsonWriter.array();
                for (String availabilityZonesListValue : availabilityZonesList) {
                    if (availabilityZonesListValue == null) continue;
                    jsonWriter.value((Object)availabilityZonesListValue);
                }
                jsonWriter.endArray();
            }
            if (!(subnetIdsList = (SdkInternalList)elasticLoadBalancer.getSubnetIds()).isEmpty() || !subnetIdsList.isAutoConstruct()) {
                jsonWriter.key("SubnetIds");
                jsonWriter.array();
                for (String subnetIdsListValue : subnetIdsList) {
                    if (subnetIdsListValue == null) continue;
                    jsonWriter.value((Object)subnetIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (!(ec2InstanceIdsList = (SdkInternalList)elasticLoadBalancer.getEc2InstanceIds()).isEmpty() || !ec2InstanceIdsList.isAutoConstruct()) {
                jsonWriter.key("Ec2InstanceIds");
                jsonWriter.array();
                for (String ec2InstanceIdsListValue : ec2InstanceIdsList) {
                    if (ec2InstanceIdsListValue == null) continue;
                    jsonWriter.value((Object)ec2InstanceIdsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ElasticLoadBalancerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ElasticLoadBalancerJsonMarshaller();
        }
        return instance;
    }
}

