/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.DescribeVolumesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class DescribeVolumesRequestMarshaller
implements Marshaller<Request<DescribeVolumesRequest>, DescribeVolumesRequest> {
    public Request<DescribeVolumesRequest> marshall(DescribeVolumesRequest describeVolumesRequest) {
        if (describeVolumesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVolumesRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DescribeVolumes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList volumeIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (describeVolumesRequest.getInstanceId() != null) {
                jsonWriter.key("InstanceId").value((Object)describeVolumesRequest.getInstanceId());
            }
            if (describeVolumesRequest.getStackId() != null) {
                jsonWriter.key("StackId").value((Object)describeVolumesRequest.getStackId());
            }
            if (describeVolumesRequest.getRaidArrayId() != null) {
                jsonWriter.key("RaidArrayId").value((Object)describeVolumesRequest.getRaidArrayId());
            }
            if (!(volumeIdsList = (SdkInternalList)describeVolumesRequest.getVolumeIds()).isEmpty() || !volumeIdsList.isAutoConstruct()) {
                jsonWriter.key("VolumeIds");
                jsonWriter.array();
                for (String volumeIdsListValue : volumeIdsList) {
                    if (volumeIdsListValue == null) continue;
                    jsonWriter.value((Object)volumeIdsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

