/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.opensearchserverless.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateAccessPolicy"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateAccessPolicyResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Details about the created access policy.
     * </p>
     */
    private AccessPolicyDetail accessPolicyDetail;

    /**
     * <p>
     * Details about the created access policy.
     * </p>
     * 
     * @param accessPolicyDetail
     *        Details about the created access policy.
     */

    public void setAccessPolicyDetail(AccessPolicyDetail accessPolicyDetail) {
        this.accessPolicyDetail = accessPolicyDetail;
    }

    /**
     * <p>
     * Details about the created access policy.
     * </p>
     * 
     * @return Details about the created access policy.
     */

    public AccessPolicyDetail getAccessPolicyDetail() {
        return this.accessPolicyDetail;
    }

    /**
     * <p>
     * Details about the created access policy.
     * </p>
     * 
     * @param accessPolicyDetail
     *        Details about the created access policy.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateAccessPolicyResult withAccessPolicyDetail(AccessPolicyDetail accessPolicyDetail) {
        setAccessPolicyDetail(accessPolicyDetail);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAccessPolicyDetail() != null)
            sb.append("AccessPolicyDetail: ").append(getAccessPolicyDetail());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateAccessPolicyResult == false)
            return false;
        CreateAccessPolicyResult other = (CreateAccessPolicyResult) obj;
        if (other.getAccessPolicyDetail() == null ^ this.getAccessPolicyDetail() == null)
            return false;
        if (other.getAccessPolicyDetail() != null && other.getAccessPolicyDetail().equals(this.getAccessPolicyDetail()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAccessPolicyDetail() == null) ? 0 : getAccessPolicyDetail().hashCode());
        return hashCode;
    }

    @Override
    public CreateAccessPolicyResult clone() {
        try {
            return (CreateAccessPolicyResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
