/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.opensearch.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Status of the advanced options for the specified domain. The following options are available:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>"rest.action.multi.allow_explicit_index": "true" | "false"</code> - Note the use of a string rather than a
 * boolean. Specifies whether explicit references to indexes are allowed inside the body of HTTP requests. If you want
 * to configure access policies for domain sub-resources, such as specific indexes and domain APIs, you must disable
 * this property. Default is true.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>"indices.fielddata.cache.size": "80" </code> - Note the use of a string rather than a boolean. Specifies the
 * percentage of heap space allocated to field data. Default is unbounded.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>"indices.query.bool.max_clause_count": "1024"</code> - Note the use of a string rather than a boolean.
 * Specifies the maximum number of clauses allowed in a Lucene boolean query. Default is 1,024. Queries with more than
 * the permitted number of clauses result in a <code>TooManyClauses</code> error.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>"override_main_response_version": "true" | "false"</code> - Note the use of a string rather than a boolean.
 * Specifies whether the domain reports its version as 7.10 to allow Elasticsearch OSS clients and plugins to continue
 * working with it. Default is false when creating a domain and true when upgrading a domain.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information, see <a href=
 * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
 * >Advanced cluster parameters</a>.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AdvancedOptionsStatus implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The status of advanced options for the specified domain.
     * </p>
     */
    private java.util.Map<String, String> options;
    /**
     * <p>
     * The status of advanced options for the specified domain.
     * </p>
     */
    private OptionStatus status;

    /**
     * <p>
     * The status of advanced options for the specified domain.
     * </p>
     * 
     * @return The status of advanced options for the specified domain.
     */

    public java.util.Map<String, String> getOptions() {
        return options;
    }

    /**
     * <p>
     * The status of advanced options for the specified domain.
     * </p>
     * 
     * @param options
     *        The status of advanced options for the specified domain.
     */

    public void setOptions(java.util.Map<String, String> options) {
        this.options = options;
    }

    /**
     * <p>
     * The status of advanced options for the specified domain.
     * </p>
     * 
     * @param options
     *        The status of advanced options for the specified domain.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AdvancedOptionsStatus withOptions(java.util.Map<String, String> options) {
        setOptions(options);
        return this;
    }

    /**
     * Add a single Options entry
     *
     * @see AdvancedOptionsStatus#withOptions
     * @returns a reference to this object so that method calls can be chained together.
     */

    public AdvancedOptionsStatus addOptionsEntry(String key, String value) {
        if (null == this.options) {
            this.options = new java.util.HashMap<String, String>();
        }
        if (this.options.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.options.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Options.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AdvancedOptionsStatus clearOptionsEntries() {
        this.options = null;
        return this;
    }

    /**
     * <p>
     * The status of advanced options for the specified domain.
     * </p>
     * 
     * @param status
     *        The status of advanced options for the specified domain.
     */

    public void setStatus(OptionStatus status) {
        this.status = status;
    }

    /**
     * <p>
     * The status of advanced options for the specified domain.
     * </p>
     * 
     * @return The status of advanced options for the specified domain.
     */

    public OptionStatus getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The status of advanced options for the specified domain.
     * </p>
     * 
     * @param status
     *        The status of advanced options for the specified domain.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AdvancedOptionsStatus withStatus(OptionStatus status) {
        setStatus(status);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getOptions() != null)
            sb.append("Options: ").append(getOptions()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AdvancedOptionsStatus == false)
            return false;
        AdvancedOptionsStatus other = (AdvancedOptionsStatus) obj;
        if (other.getOptions() == null ^ this.getOptions() == null)
            return false;
        if (other.getOptions() != null && other.getOptions().equals(this.getOptions()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getOptions() == null) ? 0 : getOptions().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        return hashCode;
    }

    @Override
    public AdvancedOptionsStatus clone() {
        try {
            return (AdvancedOptionsStatus) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.opensearch.model.transform.AdvancedOptionsStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
