/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opensearch.model.PackageVersionHistory;
import java.util.Date;

@SdkInternalApi
public class PackageVersionHistoryMarshaller {
    private static final MarshallingInfo<String> PACKAGEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PackageVersion").build();
    private static final MarshallingInfo<String> COMMITMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CommitMessage").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> PLUGINPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PluginProperties").build();
    private static final PackageVersionHistoryMarshaller instance = new PackageVersionHistoryMarshaller();

    public static PackageVersionHistoryMarshaller getInstance() {
        return instance;
    }

    public void marshall(PackageVersionHistory packageVersionHistory, ProtocolMarshaller protocolMarshaller) {
        if (packageVersionHistory == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)packageVersionHistory.getPackageVersion(), PACKAGEVERSION_BINDING);
            protocolMarshaller.marshall((Object)packageVersionHistory.getCommitMessage(), COMMITMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)packageVersionHistory.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)packageVersionHistory.getPluginProperties(), PLUGINPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

