/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opensearch.model.AutoTuneDesiredState;
import com.amazonaws.services.opensearch.model.AutoTuneMaintenanceSchedule;
import com.amazonaws.services.opensearch.model.RollbackOnDisable;
import com.amazonaws.services.opensearch.model.transform.AutoTuneOptionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AutoTuneOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private String desiredState;
    private String rollbackOnDisable;
    private List<AutoTuneMaintenanceSchedule> maintenanceSchedules;

    public void setDesiredState(String desiredState) {
        this.desiredState = desiredState;
    }

    public String getDesiredState() {
        return this.desiredState;
    }

    public AutoTuneOptions withDesiredState(String desiredState) {
        this.setDesiredState(desiredState);
        return this;
    }

    public AutoTuneOptions withDesiredState(AutoTuneDesiredState desiredState) {
        this.desiredState = desiredState.toString();
        return this;
    }

    public void setRollbackOnDisable(String rollbackOnDisable) {
        this.rollbackOnDisable = rollbackOnDisable;
    }

    public String getRollbackOnDisable() {
        return this.rollbackOnDisable;
    }

    public AutoTuneOptions withRollbackOnDisable(String rollbackOnDisable) {
        this.setRollbackOnDisable(rollbackOnDisable);
        return this;
    }

    public AutoTuneOptions withRollbackOnDisable(RollbackOnDisable rollbackOnDisable) {
        this.rollbackOnDisable = rollbackOnDisable.toString();
        return this;
    }

    public List<AutoTuneMaintenanceSchedule> getMaintenanceSchedules() {
        return this.maintenanceSchedules;
    }

    public void setMaintenanceSchedules(Collection<AutoTuneMaintenanceSchedule> maintenanceSchedules) {
        if (maintenanceSchedules == null) {
            this.maintenanceSchedules = null;
            return;
        }
        this.maintenanceSchedules = new ArrayList<AutoTuneMaintenanceSchedule>(maintenanceSchedules);
    }

    public AutoTuneOptions withMaintenanceSchedules(AutoTuneMaintenanceSchedule ... maintenanceSchedules) {
        if (this.maintenanceSchedules == null) {
            this.setMaintenanceSchedules(new ArrayList<AutoTuneMaintenanceSchedule>(maintenanceSchedules.length));
        }
        for (AutoTuneMaintenanceSchedule ele : maintenanceSchedules) {
            this.maintenanceSchedules.add(ele);
        }
        return this;
    }

    public AutoTuneOptions withMaintenanceSchedules(Collection<AutoTuneMaintenanceSchedule> maintenanceSchedules) {
        this.setMaintenanceSchedules(maintenanceSchedules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDesiredState() != null) {
            sb.append("DesiredState: ").append(this.getDesiredState()).append(",");
        }
        if (this.getRollbackOnDisable() != null) {
            sb.append("RollbackOnDisable: ").append(this.getRollbackOnDisable()).append(",");
        }
        if (this.getMaintenanceSchedules() != null) {
            sb.append("MaintenanceSchedules: ").append(this.getMaintenanceSchedules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoTuneOptions)) {
            return false;
        }
        AutoTuneOptions other = (AutoTuneOptions)obj;
        if (other.getDesiredState() == null ^ this.getDesiredState() == null) {
            return false;
        }
        if (other.getDesiredState() != null && !other.getDesiredState().equals(this.getDesiredState())) {
            return false;
        }
        if (other.getRollbackOnDisable() == null ^ this.getRollbackOnDisable() == null) {
            return false;
        }
        if (other.getRollbackOnDisable() != null && !other.getRollbackOnDisable().equals(this.getRollbackOnDisable())) {
            return false;
        }
        if (other.getMaintenanceSchedules() == null ^ this.getMaintenanceSchedules() == null) {
            return false;
        }
        return other.getMaintenanceSchedules() == null || other.getMaintenanceSchedules().equals(this.getMaintenanceSchedules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDesiredState() == null ? 0 : this.getDesiredState().hashCode());
        hashCode = 31 * hashCode + (this.getRollbackOnDisable() == null ? 0 : this.getRollbackOnDisable().hashCode());
        hashCode = 31 * hashCode + (this.getMaintenanceSchedules() == null ? 0 : this.getMaintenanceSchedules().hashCode());
        return hashCode;
    }

    public AutoTuneOptions clone() {
        try {
            return (AutoTuneOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoTuneOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

