/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opensdk.internal.protocol;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.opensdk.internal.BaseException;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.ValidationUtils;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;

@SdkInternalApi
@ThreadSafe
public class ApiGatewayErrorUnmarshaller
implements Unmarshaller<BaseException, JsonNode> {
    private static final ObjectMapper MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final Class<? extends BaseException> exceptionClass;
    private final Optional<Integer> httpStatusCode;

    public ApiGatewayErrorUnmarshaller(Class<? extends BaseException> exceptionClass, Optional<Integer> httpStatusCode) {
        this.exceptionClass = (Class)ValidationUtils.assertNotNull(exceptionClass, (String)"exceptionClass");
        this.httpStatusCode = (Optional)ValidationUtils.assertNotNull(httpStatusCode, (String)"httpStatusCode");
    }

    public BaseException unmarshall(JsonNode jsonContent) throws Exception {
        return (BaseException)MAPPER.treeToValue((TreeNode)jsonContent, this.exceptionClass);
    }

    boolean matches(int actualHttpStatusCode) {
        return this.httpStatusCode.map(sc -> sc == actualHttpStatusCode).orElse(true);
    }
}

