/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opensdk.internal.config;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.opensdk.internal.config.ApiGatewayClientConfiguration;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

@SdkInternalApi
public class ClientConfigurationAdapter {
    public static ClientConfiguration adapt(ApiGatewayClientConfiguration customConfiguration, ClientConfiguration defaultConfiguration) {
        ClientConfiguration adaptedConfiguration = new ClientConfiguration(defaultConfiguration);
        customConfiguration.getProxyConfiguration().ifPresent(proxyConfiguration -> {
            ClientConfigurationAdapter.bind(proxyConfiguration::getProtocol, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setProtocol(arg_0));
            ClientConfigurationAdapter.bind(proxyConfiguration::getProxyHost, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setProxyHost(arg_0));
            ClientConfigurationAdapter.bind(proxyConfiguration::getProxyPort, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setProxyPort(arg_0));
            ClientConfigurationAdapter.bind(proxyConfiguration::getProxyUsername, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setProxyUsername(arg_0));
            ClientConfigurationAdapter.bind(proxyConfiguration::getProxyPassword, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setProxyPassword(arg_0));
            ClientConfigurationAdapter.bind(proxyConfiguration::getProxyDomain, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setProxyDomain(arg_0));
            ClientConfigurationAdapter.bind(proxyConfiguration::getProxyWorkstation, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setProxyWorkstation(arg_0));
            ClientConfigurationAdapter.bind(proxyConfiguration::getNonProxyHosts, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setNonProxyHosts(arg_0));
            ClientConfigurationAdapter.bind(proxyConfiguration::isPreemptiveBasicProxyAuth, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setPreemptiveBasicProxyAuth(arg_0));
        });
        customConfiguration.getTimeoutConfiguration().ifPresent(timeoutConfiguration -> {
            ClientConfigurationAdapter.bind(timeoutConfiguration::getSocketTimeout, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setSocketTimeout(arg_0));
            ClientConfigurationAdapter.bind(timeoutConfiguration::getConnectionTimeout, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setConnectionTimeout(arg_0));
            ClientConfigurationAdapter.bind(timeoutConfiguration::getHttpRequestTimeout, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setRequestTimeout(arg_0));
            ClientConfigurationAdapter.bind(timeoutConfiguration::getTotalExecutionTimeout, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setClientExecutionTimeout(arg_0));
        });
        customConfiguration.getConnectionConfiguration().ifPresent(connectionConfiguration -> {
            ClientConfigurationAdapter.bind(connectionConfiguration::getMaxConnections, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setMaxConnections(arg_0));
            ClientConfigurationAdapter.bind(connectionConfiguration::getConnectionTTL, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setConnectionTTL(arg_0));
            ClientConfigurationAdapter.bind(connectionConfiguration::getConnectionMaxIdleMillis, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setConnectionMaxIdleMillis(arg_0));
            ClientConfigurationAdapter.bind(connectionConfiguration::isUseReaper, arg_0 -> ((ClientConfiguration)adaptedConfiguration).setUseReaper(arg_0));
        });
        return adaptedConfiguration;
    }

    public static <T> void bind(Supplier<Optional<T>> supplier, Consumer<T> consumer) {
        supplier.get().ifPresent(t -> consumer.accept(t));
    }
}

