/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.omics.model.Accelerators;
import com.amazonaws.services.omics.model.WorkflowEngine;
import com.amazonaws.services.omics.model.WorkflowParameter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class CreateWorkflowRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private String engine;
    private ByteBuffer definitionZip;
    private String definitionUri;
    private String main;
    private Map<String, WorkflowParameter> parameterTemplate;
    private Integer storageCapacity;
    private Map<String, String> tags;
    private String requestId;
    private String accelerators;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateWorkflowRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateWorkflowRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getEngine() {
        return this.engine;
    }

    public CreateWorkflowRequest withEngine(String engine) {
        this.setEngine(engine);
        return this;
    }

    public CreateWorkflowRequest withEngine(WorkflowEngine engine) {
        this.engine = engine.toString();
        return this;
    }

    public void setDefinitionZip(ByteBuffer definitionZip) {
        this.definitionZip = definitionZip;
    }

    public ByteBuffer getDefinitionZip() {
        return this.definitionZip;
    }

    public CreateWorkflowRequest withDefinitionZip(ByteBuffer definitionZip) {
        this.setDefinitionZip(definitionZip);
        return this;
    }

    public void setDefinitionUri(String definitionUri) {
        this.definitionUri = definitionUri;
    }

    public String getDefinitionUri() {
        return this.definitionUri;
    }

    public CreateWorkflowRequest withDefinitionUri(String definitionUri) {
        this.setDefinitionUri(definitionUri);
        return this;
    }

    public void setMain(String main) {
        this.main = main;
    }

    public String getMain() {
        return this.main;
    }

    public CreateWorkflowRequest withMain(String main) {
        this.setMain(main);
        return this;
    }

    public Map<String, WorkflowParameter> getParameterTemplate() {
        return this.parameterTemplate;
    }

    public void setParameterTemplate(Map<String, WorkflowParameter> parameterTemplate) {
        this.parameterTemplate = parameterTemplate;
    }

    public CreateWorkflowRequest withParameterTemplate(Map<String, WorkflowParameter> parameterTemplate) {
        this.setParameterTemplate(parameterTemplate);
        return this;
    }

    public CreateWorkflowRequest addParameterTemplateEntry(String key, WorkflowParameter value) {
        if (null == this.parameterTemplate) {
            this.parameterTemplate = new HashMap<String, WorkflowParameter>();
        }
        if (this.parameterTemplate.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameterTemplate.put(key, value);
        return this;
    }

    public CreateWorkflowRequest clearParameterTemplateEntries() {
        this.parameterTemplate = null;
        return this;
    }

    public void setStorageCapacity(Integer storageCapacity) {
        this.storageCapacity = storageCapacity;
    }

    public Integer getStorageCapacity() {
        return this.storageCapacity;
    }

    public CreateWorkflowRequest withStorageCapacity(Integer storageCapacity) {
        this.setStorageCapacity(storageCapacity);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateWorkflowRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateWorkflowRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateWorkflowRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public CreateWorkflowRequest withRequestId(String requestId) {
        this.setRequestId(requestId);
        return this;
    }

    public void setAccelerators(String accelerators) {
        this.accelerators = accelerators;
    }

    public String getAccelerators() {
        return this.accelerators;
    }

    public CreateWorkflowRequest withAccelerators(String accelerators) {
        this.setAccelerators(accelerators);
        return this;
    }

    public CreateWorkflowRequest withAccelerators(Accelerators accelerators) {
        this.accelerators = accelerators.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: ").append(this.getEngine()).append(",");
        }
        if (this.getDefinitionZip() != null) {
            sb.append("DefinitionZip: ").append(this.getDefinitionZip()).append(",");
        }
        if (this.getDefinitionUri() != null) {
            sb.append("DefinitionUri: ").append(this.getDefinitionUri()).append(",");
        }
        if (this.getMain() != null) {
            sb.append("Main: ").append(this.getMain()).append(",");
        }
        if (this.getParameterTemplate() != null) {
            sb.append("ParameterTemplate: ").append(this.getParameterTemplate()).append(",");
        }
        if (this.getStorageCapacity() != null) {
            sb.append("StorageCapacity: ").append(this.getStorageCapacity()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getRequestId() != null) {
            sb.append("RequestId: ").append(this.getRequestId()).append(",");
        }
        if (this.getAccelerators() != null) {
            sb.append("Accelerators: ").append(this.getAccelerators());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowRequest)) {
            return false;
        }
        CreateWorkflowRequest other = (CreateWorkflowRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getDefinitionZip() == null ^ this.getDefinitionZip() == null) {
            return false;
        }
        if (other.getDefinitionZip() != null && !other.getDefinitionZip().equals(this.getDefinitionZip())) {
            return false;
        }
        if (other.getDefinitionUri() == null ^ this.getDefinitionUri() == null) {
            return false;
        }
        if (other.getDefinitionUri() != null && !other.getDefinitionUri().equals(this.getDefinitionUri())) {
            return false;
        }
        if (other.getMain() == null ^ this.getMain() == null) {
            return false;
        }
        if (other.getMain() != null && !other.getMain().equals(this.getMain())) {
            return false;
        }
        if (other.getParameterTemplate() == null ^ this.getParameterTemplate() == null) {
            return false;
        }
        if (other.getParameterTemplate() != null && !other.getParameterTemplate().equals(this.getParameterTemplate())) {
            return false;
        }
        if (other.getStorageCapacity() == null ^ this.getStorageCapacity() == null) {
            return false;
        }
        if (other.getStorageCapacity() != null && !other.getStorageCapacity().equals(this.getStorageCapacity())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getRequestId() == null ^ this.getRequestId() == null) {
            return false;
        }
        if (other.getRequestId() != null && !other.getRequestId().equals(this.getRequestId())) {
            return false;
        }
        if (other.getAccelerators() == null ^ this.getAccelerators() == null) {
            return false;
        }
        return other.getAccelerators() == null || other.getAccelerators().equals(this.getAccelerators());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getDefinitionZip() == null ? 0 : this.getDefinitionZip().hashCode());
        hashCode = 31 * hashCode + (this.getDefinitionUri() == null ? 0 : this.getDefinitionUri().hashCode());
        hashCode = 31 * hashCode + (this.getMain() == null ? 0 : this.getMain().hashCode());
        hashCode = 31 * hashCode + (this.getParameterTemplate() == null ? 0 : this.getParameterTemplate().hashCode());
        hashCode = 31 * hashCode + (this.getStorageCapacity() == null ? 0 : this.getStorageCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getRequestId() == null ? 0 : this.getRequestId().hashCode());
        hashCode = 31 * hashCode + (this.getAccelerators() == null ? 0 : this.getAccelerators().hashCode());
        return hashCode;
    }

    public CreateWorkflowRequest clone() {
        return (CreateWorkflowRequest)super.clone();
    }
}

