/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.omics.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.SignerTypeAware;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateShare" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateShareRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable, SignerTypeAware {

    /**
     * <p>
     * The resource ARN for the analytics store to be shared.
     * </p>
     */
    private String resourceArn;
    /**
     * <p>
     * The principal subscriber is the account being given access to the analytics store data through the share offer.
     * </p>
     */
    private String principalSubscriber;
    /**
     * <p>
     * A name given to the share.
     * </p>
     */
    private String shareName;

    /**
     * <p>
     * The resource ARN for the analytics store to be shared.
     * </p>
     * 
     * @param resourceArn
     *        The resource ARN for the analytics store to be shared.
     */

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    /**
     * <p>
     * The resource ARN for the analytics store to be shared.
     * </p>
     * 
     * @return The resource ARN for the analytics store to be shared.
     */

    public String getResourceArn() {
        return this.resourceArn;
    }

    /**
     * <p>
     * The resource ARN for the analytics store to be shared.
     * </p>
     * 
     * @param resourceArn
     *        The resource ARN for the analytics store to be shared.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateShareRequest withResourceArn(String resourceArn) {
        setResourceArn(resourceArn);
        return this;
    }

    /**
     * <p>
     * The principal subscriber is the account being given access to the analytics store data through the share offer.
     * </p>
     * 
     * @param principalSubscriber
     *        The principal subscriber is the account being given access to the analytics store data through the share
     *        offer.
     */

    public void setPrincipalSubscriber(String principalSubscriber) {
        this.principalSubscriber = principalSubscriber;
    }

    /**
     * <p>
     * The principal subscriber is the account being given access to the analytics store data through the share offer.
     * </p>
     * 
     * @return The principal subscriber is the account being given access to the analytics store data through the share
     *         offer.
     */

    public String getPrincipalSubscriber() {
        return this.principalSubscriber;
    }

    /**
     * <p>
     * The principal subscriber is the account being given access to the analytics store data through the share offer.
     * </p>
     * 
     * @param principalSubscriber
     *        The principal subscriber is the account being given access to the analytics store data through the share
     *        offer.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateShareRequest withPrincipalSubscriber(String principalSubscriber) {
        setPrincipalSubscriber(principalSubscriber);
        return this;
    }

    /**
     * <p>
     * A name given to the share.
     * </p>
     * 
     * @param shareName
     *        A name given to the share.
     */

    public void setShareName(String shareName) {
        this.shareName = shareName;
    }

    /**
     * <p>
     * A name given to the share.
     * </p>
     * 
     * @return A name given to the share.
     */

    public String getShareName() {
        return this.shareName;
    }

    /**
     * <p>
     * A name given to the share.
     * </p>
     * 
     * @param shareName
     *        A name given to the share.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateShareRequest withShareName(String shareName) {
        setShareName(shareName);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getResourceArn() != null)
            sb.append("ResourceArn: ").append(getResourceArn()).append(",");
        if (getPrincipalSubscriber() != null)
            sb.append("PrincipalSubscriber: ").append(getPrincipalSubscriber()).append(",");
        if (getShareName() != null)
            sb.append("ShareName: ").append(getShareName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateShareRequest == false)
            return false;
        CreateShareRequest other = (CreateShareRequest) obj;
        if (other.getResourceArn() == null ^ this.getResourceArn() == null)
            return false;
        if (other.getResourceArn() != null && other.getResourceArn().equals(this.getResourceArn()) == false)
            return false;
        if (other.getPrincipalSubscriber() == null ^ this.getPrincipalSubscriber() == null)
            return false;
        if (other.getPrincipalSubscriber() != null && other.getPrincipalSubscriber().equals(this.getPrincipalSubscriber()) == false)
            return false;
        if (other.getShareName() == null ^ this.getShareName() == null)
            return false;
        if (other.getShareName() != null && other.getShareName().equals(this.getShareName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getResourceArn() == null) ? 0 : getResourceArn().hashCode());
        hashCode = prime * hashCode + ((getPrincipalSubscriber() == null) ? 0 : getPrincipalSubscriber().hashCode());
        hashCode = prime * hashCode + ((getShareName() == null) ? 0 : getShareName().hashCode());
        return hashCode;
    }

    @Override
    public CreateShareRequest clone() {
        return (CreateShareRequest) super.clone();
    }

    @Override
    public String getSignerType() {
        return "AWS4SignerType";
    }

}
