/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.oam.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.oam.model.ResourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateLinkRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String identifier;
    private List<String> resourceTypes;

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public UpdateLinkRequest withIdentifier(String identifier) {
        this.setIdentifier(identifier);
        return this;
    }

    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public void setResourceTypes(Collection<String> resourceTypes) {
        if (resourceTypes == null) {
            this.resourceTypes = null;
            return;
        }
        this.resourceTypes = new ArrayList<String>(resourceTypes);
    }

    public UpdateLinkRequest withResourceTypes(String ... resourceTypes) {
        if (this.resourceTypes == null) {
            this.setResourceTypes(new ArrayList<String>(resourceTypes.length));
        }
        for (String ele : resourceTypes) {
            this.resourceTypes.add(ele);
        }
        return this;
    }

    public UpdateLinkRequest withResourceTypes(Collection<String> resourceTypes) {
        this.setResourceTypes(resourceTypes);
        return this;
    }

    public UpdateLinkRequest withResourceTypes(ResourceType ... resourceTypes) {
        ArrayList<String> resourceTypesCopy = new ArrayList<String>(resourceTypes.length);
        for (ResourceType value : resourceTypes) {
            resourceTypesCopy.add(value.toString());
        }
        if (this.getResourceTypes() == null) {
            this.setResourceTypes(resourceTypesCopy);
        } else {
            this.getResourceTypes().addAll(resourceTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentifier() != null) {
            sb.append("Identifier: ").append(this.getIdentifier()).append(",");
        }
        if (this.getResourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.getResourceTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLinkRequest)) {
            return false;
        }
        UpdateLinkRequest other = (UpdateLinkRequest)obj;
        if (other.getIdentifier() == null ^ this.getIdentifier() == null) {
            return false;
        }
        if (other.getIdentifier() != null && !other.getIdentifier().equals(this.getIdentifier())) {
            return false;
        }
        if (other.getResourceTypes() == null ^ this.getResourceTypes() == null) {
            return false;
        }
        return other.getResourceTypes() == null || other.getResourceTypes().equals(this.getResourceTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypes() == null ? 0 : this.getResourceTypes().hashCode());
        return hashCode;
    }

    public UpdateLinkRequest clone() {
        return (UpdateLinkRequest)super.clone();
    }
}

