/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.nimblestudio.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.nimblestudio.model.StreamingImageEncryptionConfiguration;
import com.amazonaws.services.nimblestudio.model.StreamingImageState;
import com.amazonaws.services.nimblestudio.model.StreamingImageStatusCode;
import com.amazonaws.services.nimblestudio.model.transform.StreamingImageMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StreamingImage
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String description;
    private String ec2ImageId;
    private StreamingImageEncryptionConfiguration encryptionConfiguration;
    private List<String> eulaIds;
    private String name;
    private String owner;
    private String platform;
    private String state;
    private String statusCode;
    private String statusMessage;
    private String streamingImageId;
    private Map<String, String> tags;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public StreamingImage withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public StreamingImage withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setEc2ImageId(String ec2ImageId) {
        this.ec2ImageId = ec2ImageId;
    }

    public String getEc2ImageId() {
        return this.ec2ImageId;
    }

    public StreamingImage withEc2ImageId(String ec2ImageId) {
        this.setEc2ImageId(ec2ImageId);
        return this;
    }

    public void setEncryptionConfiguration(StreamingImageEncryptionConfiguration encryptionConfiguration) {
        this.encryptionConfiguration = encryptionConfiguration;
    }

    public StreamingImageEncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public StreamingImage withEncryptionConfiguration(StreamingImageEncryptionConfiguration encryptionConfiguration) {
        this.setEncryptionConfiguration(encryptionConfiguration);
        return this;
    }

    public List<String> getEulaIds() {
        return this.eulaIds;
    }

    public void setEulaIds(Collection<String> eulaIds) {
        if (eulaIds == null) {
            this.eulaIds = null;
            return;
        }
        this.eulaIds = new ArrayList<String>(eulaIds);
    }

    public StreamingImage withEulaIds(String ... eulaIds) {
        if (this.eulaIds == null) {
            this.setEulaIds(new ArrayList<String>(eulaIds.length));
        }
        for (String ele : eulaIds) {
            this.eulaIds.add(ele);
        }
        return this;
    }

    public StreamingImage withEulaIds(Collection<String> eulaIds) {
        this.setEulaIds(eulaIds);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public StreamingImage withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public StreamingImage withOwner(String owner) {
        this.setOwner(owner);
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public StreamingImage withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public StreamingImage withState(String state) {
        this.setState(state);
        return this;
    }

    public StreamingImage withState(StreamingImageState state) {
        this.state = state.toString();
        return this;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public StreamingImage withStatusCode(String statusCode) {
        this.setStatusCode(statusCode);
        return this;
    }

    public StreamingImage withStatusCode(StreamingImageStatusCode statusCode) {
        this.statusCode = statusCode.toString();
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public StreamingImage withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public void setStreamingImageId(String streamingImageId) {
        this.streamingImageId = streamingImageId;
    }

    public String getStreamingImageId() {
        return this.streamingImageId;
    }

    public StreamingImage withStreamingImageId(String streamingImageId) {
        this.setStreamingImageId(streamingImageId);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public StreamingImage withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public StreamingImage addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public StreamingImage clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getEc2ImageId() != null) {
            sb.append("Ec2ImageId: ").append(this.getEc2ImageId()).append(",");
        }
        if (this.getEncryptionConfiguration() != null) {
            sb.append("EncryptionConfiguration: ").append(this.getEncryptionConfiguration()).append(",");
        }
        if (this.getEulaIds() != null) {
            sb.append("EulaIds: ").append(this.getEulaIds()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getStatusCode() != null) {
            sb.append("StatusCode: ").append(this.getStatusCode()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage()).append(",");
        }
        if (this.getStreamingImageId() != null) {
            sb.append("StreamingImageId: ").append(this.getStreamingImageId()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingImage)) {
            return false;
        }
        StreamingImage other = (StreamingImage)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEc2ImageId() == null ^ this.getEc2ImageId() == null) {
            return false;
        }
        if (other.getEc2ImageId() != null && !other.getEc2ImageId().equals(this.getEc2ImageId())) {
            return false;
        }
        if (other.getEncryptionConfiguration() == null ^ this.getEncryptionConfiguration() == null) {
            return false;
        }
        if (other.getEncryptionConfiguration() != null && !other.getEncryptionConfiguration().equals(this.getEncryptionConfiguration())) {
            return false;
        }
        if (other.getEulaIds() == null ^ this.getEulaIds() == null) {
            return false;
        }
        if (other.getEulaIds() != null && !other.getEulaIds().equals(this.getEulaIds())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStatusCode() == null ^ this.getStatusCode() == null) {
            return false;
        }
        if (other.getStatusCode() != null && !other.getStatusCode().equals(this.getStatusCode())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getStreamingImageId() == null ^ this.getStreamingImageId() == null) {
            return false;
        }
        if (other.getStreamingImageId() != null && !other.getStreamingImageId().equals(this.getStreamingImageId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEc2ImageId() == null ? 0 : this.getEc2ImageId().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionConfiguration() == null ? 0 : this.getEncryptionConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getEulaIds() == null ? 0 : this.getEulaIds().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStatusCode() == null ? 0 : this.getStatusCode().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getStreamingImageId() == null ? 0 : this.getStreamingImageId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public StreamingImage clone() {
        try {
            return (StreamingImage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamingImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

