/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmonitor;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.networkmonitor.AmazonNetworkMonitorAsync;
import com.amazonaws.services.networkmonitor.AmazonNetworkMonitorAsyncClientBuilder;
import com.amazonaws.services.networkmonitor.AmazonNetworkMonitorClient;
import com.amazonaws.services.networkmonitor.model.CreateMonitorRequest;
import com.amazonaws.services.networkmonitor.model.CreateMonitorResult;
import com.amazonaws.services.networkmonitor.model.CreateProbeRequest;
import com.amazonaws.services.networkmonitor.model.CreateProbeResult;
import com.amazonaws.services.networkmonitor.model.DeleteMonitorRequest;
import com.amazonaws.services.networkmonitor.model.DeleteMonitorResult;
import com.amazonaws.services.networkmonitor.model.DeleteProbeRequest;
import com.amazonaws.services.networkmonitor.model.DeleteProbeResult;
import com.amazonaws.services.networkmonitor.model.GetMonitorRequest;
import com.amazonaws.services.networkmonitor.model.GetMonitorResult;
import com.amazonaws.services.networkmonitor.model.GetProbeRequest;
import com.amazonaws.services.networkmonitor.model.GetProbeResult;
import com.amazonaws.services.networkmonitor.model.ListMonitorsRequest;
import com.amazonaws.services.networkmonitor.model.ListMonitorsResult;
import com.amazonaws.services.networkmonitor.model.ListTagsForResourceRequest;
import com.amazonaws.services.networkmonitor.model.ListTagsForResourceResult;
import com.amazonaws.services.networkmonitor.model.TagResourceRequest;
import com.amazonaws.services.networkmonitor.model.TagResourceResult;
import com.amazonaws.services.networkmonitor.model.UntagResourceRequest;
import com.amazonaws.services.networkmonitor.model.UntagResourceResult;
import com.amazonaws.services.networkmonitor.model.UpdateMonitorRequest;
import com.amazonaws.services.networkmonitor.model.UpdateMonitorResult;
import com.amazonaws.services.networkmonitor.model.UpdateProbeRequest;
import com.amazonaws.services.networkmonitor.model.UpdateProbeResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonNetworkMonitorAsyncClient
extends AmazonNetworkMonitorClient
implements AmazonNetworkMonitorAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonNetworkMonitorAsyncClientBuilder asyncBuilder() {
        return AmazonNetworkMonitorAsyncClientBuilder.standard();
    }

    AmazonNetworkMonitorAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonNetworkMonitorAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateMonitorResult> createMonitorAsync(CreateMonitorRequest request) {
        return this.createMonitorAsync(request, null);
    }

    @Override
    public Future<CreateMonitorResult> createMonitorAsync(CreateMonitorRequest request, final AsyncHandler<CreateMonitorRequest, CreateMonitorResult> asyncHandler) {
        final CreateMonitorRequest finalRequest = (CreateMonitorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMonitorResult>(){

            @Override
            public CreateMonitorResult call() throws Exception {
                CreateMonitorResult result = null;
                try {
                    result = AmazonNetworkMonitorAsyncClient.this.executeCreateMonitor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateProbeResult> createProbeAsync(CreateProbeRequest request) {
        return this.createProbeAsync(request, null);
    }

    @Override
    public Future<CreateProbeResult> createProbeAsync(CreateProbeRequest request, final AsyncHandler<CreateProbeRequest, CreateProbeResult> asyncHandler) {
        final CreateProbeRequest finalRequest = (CreateProbeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateProbeResult>(){

            @Override
            public CreateProbeResult call() throws Exception {
                CreateProbeResult result = null;
                try {
                    result = AmazonNetworkMonitorAsyncClient.this.executeCreateProbe(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMonitorResult> deleteMonitorAsync(DeleteMonitorRequest request) {
        return this.deleteMonitorAsync(request, null);
    }

    @Override
    public Future<DeleteMonitorResult> deleteMonitorAsync(DeleteMonitorRequest request, final AsyncHandler<DeleteMonitorRequest, DeleteMonitorResult> asyncHandler) {
        final DeleteMonitorRequest finalRequest = (DeleteMonitorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMonitorResult>(){

            @Override
            public DeleteMonitorResult call() throws Exception {
                DeleteMonitorResult result = null;
                try {
                    result = AmazonNetworkMonitorAsyncClient.this.executeDeleteMonitor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteProbeResult> deleteProbeAsync(DeleteProbeRequest request) {
        return this.deleteProbeAsync(request, null);
    }

    @Override
    public Future<DeleteProbeResult> deleteProbeAsync(DeleteProbeRequest request, final AsyncHandler<DeleteProbeRequest, DeleteProbeResult> asyncHandler) {
        final DeleteProbeRequest finalRequest = (DeleteProbeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteProbeResult>(){

            @Override
            public DeleteProbeResult call() throws Exception {
                DeleteProbeResult result = null;
                try {
                    result = AmazonNetworkMonitorAsyncClient.this.executeDeleteProbe(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMonitorResult> getMonitorAsync(GetMonitorRequest request) {
        return this.getMonitorAsync(request, null);
    }

    @Override
    public Future<GetMonitorResult> getMonitorAsync(GetMonitorRequest request, final AsyncHandler<GetMonitorRequest, GetMonitorResult> asyncHandler) {
        final GetMonitorRequest finalRequest = (GetMonitorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMonitorResult>(){

            @Override
            public GetMonitorResult call() throws Exception {
                GetMonitorResult result = null;
                try {
                    result = AmazonNetworkMonitorAsyncClient.this.executeGetMonitor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProbeResult> getProbeAsync(GetProbeRequest request) {
        return this.getProbeAsync(request, null);
    }

    @Override
    public Future<GetProbeResult> getProbeAsync(GetProbeRequest request, final AsyncHandler<GetProbeRequest, GetProbeResult> asyncHandler) {
        final GetProbeRequest finalRequest = (GetProbeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetProbeResult>(){

            @Override
            public GetProbeResult call() throws Exception {
                GetProbeResult result = null;
                try {
                    result = AmazonNetworkMonitorAsyncClient.this.executeGetProbe(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMonitorsResult> listMonitorsAsync(ListMonitorsRequest request) {
        return this.listMonitorsAsync(request, null);
    }

    @Override
    public Future<ListMonitorsResult> listMonitorsAsync(ListMonitorsRequest request, final AsyncHandler<ListMonitorsRequest, ListMonitorsResult> asyncHandler) {
        final ListMonitorsRequest finalRequest = (ListMonitorsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMonitorsResult>(){

            @Override
            public ListMonitorsResult call() throws Exception {
                ListMonitorsResult result = null;
                try {
                    result = AmazonNetworkMonitorAsyncClient.this.executeListMonitors(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonNetworkMonitorAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonNetworkMonitorAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonNetworkMonitorAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateMonitorResult> updateMonitorAsync(UpdateMonitorRequest request) {
        return this.updateMonitorAsync(request, null);
    }

    @Override
    public Future<UpdateMonitorResult> updateMonitorAsync(UpdateMonitorRequest request, final AsyncHandler<UpdateMonitorRequest, UpdateMonitorResult> asyncHandler) {
        final UpdateMonitorRequest finalRequest = (UpdateMonitorRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateMonitorResult>(){

            @Override
            public UpdateMonitorResult call() throws Exception {
                UpdateMonitorResult result = null;
                try {
                    result = AmazonNetworkMonitorAsyncClient.this.executeUpdateMonitor(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateProbeResult> updateProbeAsync(UpdateProbeRequest request) {
        return this.updateProbeAsync(request, null);
    }

    @Override
    public Future<UpdateProbeResult> updateProbeAsync(UpdateProbeRequest request, final AsyncHandler<UpdateProbeRequest, UpdateProbeResult> asyncHandler) {
        final UpdateProbeRequest finalRequest = (UpdateProbeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateProbeResult>(){

            @Override
            public UpdateProbeResult call() throws Exception {
                UpdateProbeResult result = null;
                try {
                    result = AmazonNetworkMonitorAsyncClient.this.executeUpdateProbe(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

