/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkfirewall.model.Address;
import com.amazonaws.services.networkfirewall.model.PortRange;
import com.amazonaws.services.networkfirewall.model.TCPFlagField;
import com.amazonaws.services.networkfirewall.model.transform.MatchAttributesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MatchAttributes
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Address> sources;
    private List<Address> destinations;
    private List<PortRange> sourcePorts;
    private List<PortRange> destinationPorts;
    private List<Integer> protocols;
    private List<TCPFlagField> tCPFlags;

    public List<Address> getSources() {
        return this.sources;
    }

    public void setSources(Collection<Address> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<Address>(sources);
    }

    public MatchAttributes withSources(Address ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<Address>(sources.length));
        }
        for (Address ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public MatchAttributes withSources(Collection<Address> sources) {
        this.setSources(sources);
        return this;
    }

    public List<Address> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<Address> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<Address>(destinations);
    }

    public MatchAttributes withDestinations(Address ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<Address>(destinations.length));
        }
        for (Address ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public MatchAttributes withDestinations(Collection<Address> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public List<PortRange> getSourcePorts() {
        return this.sourcePorts;
    }

    public void setSourcePorts(Collection<PortRange> sourcePorts) {
        if (sourcePorts == null) {
            this.sourcePorts = null;
            return;
        }
        this.sourcePorts = new ArrayList<PortRange>(sourcePorts);
    }

    public MatchAttributes withSourcePorts(PortRange ... sourcePorts) {
        if (this.sourcePorts == null) {
            this.setSourcePorts(new ArrayList<PortRange>(sourcePorts.length));
        }
        for (PortRange ele : sourcePorts) {
            this.sourcePorts.add(ele);
        }
        return this;
    }

    public MatchAttributes withSourcePorts(Collection<PortRange> sourcePorts) {
        this.setSourcePorts(sourcePorts);
        return this;
    }

    public List<PortRange> getDestinationPorts() {
        return this.destinationPorts;
    }

    public void setDestinationPorts(Collection<PortRange> destinationPorts) {
        if (destinationPorts == null) {
            this.destinationPorts = null;
            return;
        }
        this.destinationPorts = new ArrayList<PortRange>(destinationPorts);
    }

    public MatchAttributes withDestinationPorts(PortRange ... destinationPorts) {
        if (this.destinationPorts == null) {
            this.setDestinationPorts(new ArrayList<PortRange>(destinationPorts.length));
        }
        for (PortRange ele : destinationPorts) {
            this.destinationPorts.add(ele);
        }
        return this;
    }

    public MatchAttributes withDestinationPorts(Collection<PortRange> destinationPorts) {
        this.setDestinationPorts(destinationPorts);
        return this;
    }

    public List<Integer> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(Collection<Integer> protocols) {
        if (protocols == null) {
            this.protocols = null;
            return;
        }
        this.protocols = new ArrayList<Integer>(protocols);
    }

    public MatchAttributes withProtocols(Integer ... protocols) {
        if (this.protocols == null) {
            this.setProtocols(new ArrayList<Integer>(protocols.length));
        }
        for (Integer ele : protocols) {
            this.protocols.add(ele);
        }
        return this;
    }

    public MatchAttributes withProtocols(Collection<Integer> protocols) {
        this.setProtocols(protocols);
        return this;
    }

    public List<TCPFlagField> getTCPFlags() {
        return this.tCPFlags;
    }

    public void setTCPFlags(Collection<TCPFlagField> tCPFlags) {
        if (tCPFlags == null) {
            this.tCPFlags = null;
            return;
        }
        this.tCPFlags = new ArrayList<TCPFlagField>(tCPFlags);
    }

    public MatchAttributes withTCPFlags(TCPFlagField ... tCPFlags) {
        if (this.tCPFlags == null) {
            this.setTCPFlags(new ArrayList<TCPFlagField>(tCPFlags.length));
        }
        for (TCPFlagField ele : tCPFlags) {
            this.tCPFlags.add(ele);
        }
        return this;
    }

    public MatchAttributes withTCPFlags(Collection<TCPFlagField> tCPFlags) {
        this.setTCPFlags(tCPFlags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources()).append(",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getSourcePorts() != null) {
            sb.append("SourcePorts: ").append(this.getSourcePorts()).append(",");
        }
        if (this.getDestinationPorts() != null) {
            sb.append("DestinationPorts: ").append(this.getDestinationPorts()).append(",");
        }
        if (this.getProtocols() != null) {
            sb.append("Protocols: ").append(this.getProtocols()).append(",");
        }
        if (this.getTCPFlags() != null) {
            sb.append("TCPFlags: ").append(this.getTCPFlags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchAttributes)) {
            return false;
        }
        MatchAttributes other = (MatchAttributes)obj;
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        if (other.getSources() != null && !other.getSources().equals(this.getSources())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getSourcePorts() == null ^ this.getSourcePorts() == null) {
            return false;
        }
        if (other.getSourcePorts() != null && !other.getSourcePorts().equals(this.getSourcePorts())) {
            return false;
        }
        if (other.getDestinationPorts() == null ^ this.getDestinationPorts() == null) {
            return false;
        }
        if (other.getDestinationPorts() != null && !other.getDestinationPorts().equals(this.getDestinationPorts())) {
            return false;
        }
        if (other.getProtocols() == null ^ this.getProtocols() == null) {
            return false;
        }
        if (other.getProtocols() != null && !other.getProtocols().equals(this.getProtocols())) {
            return false;
        }
        if (other.getTCPFlags() == null ^ this.getTCPFlags() == null) {
            return false;
        }
        return other.getTCPFlags() == null || other.getTCPFlags().equals(this.getTCPFlags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getSourcePorts() == null ? 0 : this.getSourcePorts().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationPorts() == null ? 0 : this.getDestinationPorts().hashCode());
        hashCode = 31 * hashCode + (this.getProtocols() == null ? 0 : this.getProtocols().hashCode());
        hashCode = 31 * hashCode + (this.getTCPFlags() == null ? 0 : this.getTCPFlags().hashCode());
        return hashCode;
    }

    public MatchAttributes clone() {
        try {
            return (MatchAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MatchAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

