/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptunedata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.neptunedata.model.transform.EdgeStructureMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EdgeStructure
implements Serializable,
Cloneable,
StructuredPojo {
    private Long count;
    private List<String> edgeProperties;

    public void setCount(Long count) {
        this.count = count;
    }

    public Long getCount() {
        return this.count;
    }

    public EdgeStructure withCount(Long count) {
        this.setCount(count);
        return this;
    }

    public List<String> getEdgeProperties() {
        return this.edgeProperties;
    }

    public void setEdgeProperties(Collection<String> edgeProperties) {
        if (edgeProperties == null) {
            this.edgeProperties = null;
            return;
        }
        this.edgeProperties = new ArrayList<String>(edgeProperties);
    }

    public EdgeStructure withEdgeProperties(String ... edgeProperties) {
        if (this.edgeProperties == null) {
            this.setEdgeProperties(new ArrayList<String>(edgeProperties.length));
        }
        for (String ele : edgeProperties) {
            this.edgeProperties.add(ele);
        }
        return this;
    }

    public EdgeStructure withEdgeProperties(Collection<String> edgeProperties) {
        this.setEdgeProperties(edgeProperties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCount() != null) {
            sb.append("Count: ").append(this.getCount()).append(",");
        }
        if (this.getEdgeProperties() != null) {
            sb.append("EdgeProperties: ").append(this.getEdgeProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeStructure)) {
            return false;
        }
        EdgeStructure other = (EdgeStructure)obj;
        if (other.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        if (other.getCount() != null && !other.getCount().equals(this.getCount())) {
            return false;
        }
        if (other.getEdgeProperties() == null ^ this.getEdgeProperties() == null) {
            return false;
        }
        return other.getEdgeProperties() == null || other.getEdgeProperties().equals(this.getEdgeProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCount() == null ? 0 : this.getCount().hashCode());
        hashCode = 31 * hashCode + (this.getEdgeProperties() == null ? 0 : this.getEdgeProperties().hashCode());
        return hashCode;
    }

    public EdgeStructure clone() {
        try {
            return (EdgeStructure)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EdgeStructureMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

