/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.neptune.model.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import com.amazonaws.services.neptune.model.*;
import com.amazonaws.transform.Unmarshaller;

import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ServerlessV2ScalingConfiguration StAX Unmarshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ServerlessV2ScalingConfigurationStaxUnmarshaller implements Unmarshaller<ServerlessV2ScalingConfiguration, StaxUnmarshallerContext> {

    public ServerlessV2ScalingConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration = new ServerlessV2ScalingConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument())
                return serverlessV2ScalingConfiguration;

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("MinCapacity", targetDepth)) {
                    serverlessV2ScalingConfiguration.setMinCapacity(DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxCapacity", targetDepth)) {
                    serverlessV2ScalingConfiguration.setMaxCapacity(DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    return serverlessV2ScalingConfiguration;
                }
            }
        }
    }

    private static ServerlessV2ScalingConfigurationStaxUnmarshaller instance;

    public static ServerlessV2ScalingConfigurationStaxUnmarshaller getInstance() {
        if (instance == null)
            instance = new ServerlessV2ScalingConfigurationStaxUnmarshaller();
        return instance;
    }
}
