/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.neptune.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.neptune.model.CopyDBParameterGroupRequest;
import com.amazonaws.services.neptune.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CopyDBParameterGroupRequestMarshaller
implements Marshaller<Request<CopyDBParameterGroupRequest>, CopyDBParameterGroupRequest> {
    public Request<CopyDBParameterGroupRequest> marshall(CopyDBParameterGroupRequest copyDBParameterGroupRequest) {
        if (copyDBParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)copyDBParameterGroupRequest, "AmazonNeptune");
        request.addParameter("Action", "CopyDBParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyDBParameterGroupRequest.getSourceDBParameterGroupIdentifier() != null) {
            request.addParameter("SourceDBParameterGroupIdentifier", StringUtils.fromString((String)copyDBParameterGroupRequest.getSourceDBParameterGroupIdentifier()));
        }
        if (copyDBParameterGroupRequest.getTargetDBParameterGroupIdentifier() != null) {
            request.addParameter("TargetDBParameterGroupIdentifier", StringUtils.fromString((String)copyDBParameterGroupRequest.getTargetDBParameterGroupIdentifier()));
        }
        if (copyDBParameterGroupRequest.getTargetDBParameterGroupDescription() != null) {
            request.addParameter("TargetDBParameterGroupDescription", StringUtils.fromString((String)copyDBParameterGroupRequest.getTargetDBParameterGroupDescription()));
        }
        if (copyDBParameterGroupRequest.getTags() != null) {
            List<Tag> tagsList = copyDBParameterGroupRequest.getTags();
            if (tagsList.isEmpty()) {
                request.addParameter("Tags", "");
            } else {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue != null) {
                        if (tagsListValue.getKey() != null) {
                            request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                        }
                        if (tagsListValue.getValue() != null) {
                            request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                        }
                    }
                    ++tagsListIndex;
                }
            }
        }
        return request;
    }
}

