/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.memorydb.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.memorydb.model.Authentication;
import com.amazonaws.services.memorydb.model.transform.UserMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class User
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String status;
    private String accessString;
    private List<String> aCLNames;
    private String minimumEngineVersion;
    private Authentication authentication;
    private String aRN;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public User withName(String name) {
        this.setName(name);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public User withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setAccessString(String accessString) {
        this.accessString = accessString;
    }

    public String getAccessString() {
        return this.accessString;
    }

    public User withAccessString(String accessString) {
        this.setAccessString(accessString);
        return this;
    }

    public List<String> getACLNames() {
        return this.aCLNames;
    }

    public void setACLNames(Collection<String> aCLNames) {
        if (aCLNames == null) {
            this.aCLNames = null;
            return;
        }
        this.aCLNames = new ArrayList<String>(aCLNames);
    }

    public User withACLNames(String ... aCLNames) {
        if (this.aCLNames == null) {
            this.setACLNames(new ArrayList<String>(aCLNames.length));
        }
        for (String ele : aCLNames) {
            this.aCLNames.add(ele);
        }
        return this;
    }

    public User withACLNames(Collection<String> aCLNames) {
        this.setACLNames(aCLNames);
        return this;
    }

    public void setMinimumEngineVersion(String minimumEngineVersion) {
        this.minimumEngineVersion = minimumEngineVersion;
    }

    public String getMinimumEngineVersion() {
        return this.minimumEngineVersion;
    }

    public User withMinimumEngineVersion(String minimumEngineVersion) {
        this.setMinimumEngineVersion(minimumEngineVersion);
        return this;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public User withAuthentication(Authentication authentication) {
        this.setAuthentication(authentication);
        return this;
    }

    public void setARN(String aRN) {
        this.aRN = aRN;
    }

    public String getARN() {
        return this.aRN;
    }

    public User withARN(String aRN) {
        this.setARN(aRN);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getAccessString() != null) {
            sb.append("AccessString: ").append(this.getAccessString()).append(",");
        }
        if (this.getACLNames() != null) {
            sb.append("ACLNames: ").append(this.getACLNames()).append(",");
        }
        if (this.getMinimumEngineVersion() != null) {
            sb.append("MinimumEngineVersion: ").append(this.getMinimumEngineVersion()).append(",");
        }
        if (this.getAuthentication() != null) {
            sb.append("Authentication: ").append(this.getAuthentication()).append(",");
        }
        if (this.getARN() != null) {
            sb.append("ARN: ").append(this.getARN());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getAccessString() == null ^ this.getAccessString() == null) {
            return false;
        }
        if (other.getAccessString() != null && !other.getAccessString().equals(this.getAccessString())) {
            return false;
        }
        if (other.getACLNames() == null ^ this.getACLNames() == null) {
            return false;
        }
        if (other.getACLNames() != null && !other.getACLNames().equals(this.getACLNames())) {
            return false;
        }
        if (other.getMinimumEngineVersion() == null ^ this.getMinimumEngineVersion() == null) {
            return false;
        }
        if (other.getMinimumEngineVersion() != null && !other.getMinimumEngineVersion().equals(this.getMinimumEngineVersion())) {
            return false;
        }
        if (other.getAuthentication() == null ^ this.getAuthentication() == null) {
            return false;
        }
        if (other.getAuthentication() != null && !other.getAuthentication().equals(this.getAuthentication())) {
            return false;
        }
        if (other.getARN() == null ^ this.getARN() == null) {
            return false;
        }
        return other.getARN() == null || other.getARN().equals(this.getARN());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAccessString() == null ? 0 : this.getAccessString().hashCode());
        hashCode = 31 * hashCode + (this.getACLNames() == null ? 0 : this.getACLNames().hashCode());
        hashCode = 31 * hashCode + (this.getMinimumEngineVersion() == null ? 0 : this.getMinimumEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAuthentication() == null ? 0 : this.getAuthentication().hashCode());
        hashCode = 31 * hashCode + (this.getARN() == null ? 0 : this.getARN().hashCode());
        return hashCode;
    }

    public User clone() {
        try {
            return (User)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UserMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

