/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.memorydb.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.memorydb.model.InputAuthenticationType;
import com.amazonaws.services.memorydb.model.transform.AuthenticationModeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AuthenticationMode
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private List<String> passwords;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public AuthenticationMode withType(String type) {
        this.setType(type);
        return this;
    }

    public AuthenticationMode withType(InputAuthenticationType type) {
        this.type = type.toString();
        return this;
    }

    public List<String> getPasswords() {
        return this.passwords;
    }

    public void setPasswords(Collection<String> passwords) {
        if (passwords == null) {
            this.passwords = null;
            return;
        }
        this.passwords = new ArrayList<String>(passwords);
    }

    public AuthenticationMode withPasswords(String ... passwords) {
        if (this.passwords == null) {
            this.setPasswords(new ArrayList<String>(passwords.length));
        }
        for (String ele : passwords) {
            this.passwords.add(ele);
        }
        return this;
    }

    public AuthenticationMode withPasswords(Collection<String> passwords) {
        this.setPasswords(passwords);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getPasswords() != null) {
            sb.append("Passwords: ").append(this.getPasswords());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationMode)) {
            return false;
        }
        AuthenticationMode other = (AuthenticationMode)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getPasswords() == null ^ this.getPasswords() == null) {
            return false;
        }
        return other.getPasswords() == null || other.getPasswords().equals(this.getPasswords());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getPasswords() == null ? 0 : this.getPasswords().hashCode());
        return hashCode;
    }

    public AuthenticationMode clone() {
        try {
            return (AuthenticationMode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AuthenticationModeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

