/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.memorydb.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.memorydb.model.Cluster;
import com.amazonaws.services.memorydb.model.UnprocessedCluster;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchUpdateClusterResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Cluster> processedClusters;
    private List<UnprocessedCluster> unprocessedClusters;

    public List<Cluster> getProcessedClusters() {
        return this.processedClusters;
    }

    public void setProcessedClusters(Collection<Cluster> processedClusters) {
        if (processedClusters == null) {
            this.processedClusters = null;
            return;
        }
        this.processedClusters = new ArrayList<Cluster>(processedClusters);
    }

    public BatchUpdateClusterResult withProcessedClusters(Cluster ... processedClusters) {
        if (this.processedClusters == null) {
            this.setProcessedClusters(new ArrayList<Cluster>(processedClusters.length));
        }
        for (Cluster ele : processedClusters) {
            this.processedClusters.add(ele);
        }
        return this;
    }

    public BatchUpdateClusterResult withProcessedClusters(Collection<Cluster> processedClusters) {
        this.setProcessedClusters(processedClusters);
        return this;
    }

    public List<UnprocessedCluster> getUnprocessedClusters() {
        return this.unprocessedClusters;
    }

    public void setUnprocessedClusters(Collection<UnprocessedCluster> unprocessedClusters) {
        if (unprocessedClusters == null) {
            this.unprocessedClusters = null;
            return;
        }
        this.unprocessedClusters = new ArrayList<UnprocessedCluster>(unprocessedClusters);
    }

    public BatchUpdateClusterResult withUnprocessedClusters(UnprocessedCluster ... unprocessedClusters) {
        if (this.unprocessedClusters == null) {
            this.setUnprocessedClusters(new ArrayList<UnprocessedCluster>(unprocessedClusters.length));
        }
        for (UnprocessedCluster ele : unprocessedClusters) {
            this.unprocessedClusters.add(ele);
        }
        return this;
    }

    public BatchUpdateClusterResult withUnprocessedClusters(Collection<UnprocessedCluster> unprocessedClusters) {
        this.setUnprocessedClusters(unprocessedClusters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProcessedClusters() != null) {
            sb.append("ProcessedClusters: ").append(this.getProcessedClusters()).append(",");
        }
        if (this.getUnprocessedClusters() != null) {
            sb.append("UnprocessedClusters: ").append(this.getUnprocessedClusters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateClusterResult)) {
            return false;
        }
        BatchUpdateClusterResult other = (BatchUpdateClusterResult)obj;
        if (other.getProcessedClusters() == null ^ this.getProcessedClusters() == null) {
            return false;
        }
        if (other.getProcessedClusters() != null && !other.getProcessedClusters().equals(this.getProcessedClusters())) {
            return false;
        }
        if (other.getUnprocessedClusters() == null ^ this.getUnprocessedClusters() == null) {
            return false;
        }
        return other.getUnprocessedClusters() == null || other.getUnprocessedClusters().equals(this.getUnprocessedClusters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProcessedClusters() == null ? 0 : this.getProcessedClusters().hashCode());
        hashCode = 31 * hashCode + (this.getUnprocessedClusters() == null ? 0 : this.getUnprocessedClusters().hashCode());
        return hashCode;
    }

    public BatchUpdateClusterResult clone() {
        try {
            return (BatchUpdateClusterResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

