/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediatailor.model.AudienceMedia;
import java.util.List;

@SdkInternalApi
public class AudienceMediaMarshaller {
    private static final MarshallingInfo<List> ALTERNATEMEDIA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AlternateMedia").build();
    private static final MarshallingInfo<String> AUDIENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Audience").build();
    private static final AudienceMediaMarshaller instance = new AudienceMediaMarshaller();

    public static AudienceMediaMarshaller getInstance() {
        return instance;
    }

    public void marshall(AudienceMedia audienceMedia, ProtocolMarshaller protocolMarshaller) {
        if (audienceMedia == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(audienceMedia.getAlternateMedia(), ALTERNATEMEDIA_BINDING);
            protocolMarshaller.marshall((Object)audienceMedia.getAudience(), AUDIENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

