/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediatailor.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.mediatailor.model.RequestOutputItem;
import com.amazonaws.services.mediatailor.model.SlateSource;
import com.amazonaws.services.mediatailor.model.TimeShiftConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateChannelRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> audiences;
    private String channelName;
    private SlateSource fillerSlate;
    private List<RequestOutputItem> outputs;
    private TimeShiftConfiguration timeShiftConfiguration;

    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(Collection<String> audiences) {
        if (audiences == null) {
            this.audiences = null;
            return;
        }
        this.audiences = new ArrayList<String>(audiences);
    }

    public UpdateChannelRequest withAudiences(String ... audiences) {
        if (this.audiences == null) {
            this.setAudiences(new ArrayList<String>(audiences.length));
        }
        for (String ele : audiences) {
            this.audiences.add(ele);
        }
        return this;
    }

    public UpdateChannelRequest withAudiences(Collection<String> audiences) {
        this.setAudiences(audiences);
        return this;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public UpdateChannelRequest withChannelName(String channelName) {
        this.setChannelName(channelName);
        return this;
    }

    public void setFillerSlate(SlateSource fillerSlate) {
        this.fillerSlate = fillerSlate;
    }

    public SlateSource getFillerSlate() {
        return this.fillerSlate;
    }

    public UpdateChannelRequest withFillerSlate(SlateSource fillerSlate) {
        this.setFillerSlate(fillerSlate);
        return this;
    }

    public List<RequestOutputItem> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<RequestOutputItem> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new ArrayList<RequestOutputItem>(outputs);
    }

    public UpdateChannelRequest withOutputs(RequestOutputItem ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new ArrayList<RequestOutputItem>(outputs.length));
        }
        for (RequestOutputItem ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public UpdateChannelRequest withOutputs(Collection<RequestOutputItem> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public void setTimeShiftConfiguration(TimeShiftConfiguration timeShiftConfiguration) {
        this.timeShiftConfiguration = timeShiftConfiguration;
    }

    public TimeShiftConfiguration getTimeShiftConfiguration() {
        return this.timeShiftConfiguration;
    }

    public UpdateChannelRequest withTimeShiftConfiguration(TimeShiftConfiguration timeShiftConfiguration) {
        this.setTimeShiftConfiguration(timeShiftConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAudiences() != null) {
            sb.append("Audiences: ").append(this.getAudiences()).append(",");
        }
        if (this.getChannelName() != null) {
            sb.append("ChannelName: ").append(this.getChannelName()).append(",");
        }
        if (this.getFillerSlate() != null) {
            sb.append("FillerSlate: ").append(this.getFillerSlate()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getTimeShiftConfiguration() != null) {
            sb.append("TimeShiftConfiguration: ").append(this.getTimeShiftConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelRequest)) {
            return false;
        }
        UpdateChannelRequest other = (UpdateChannelRequest)obj;
        if (other.getAudiences() == null ^ this.getAudiences() == null) {
            return false;
        }
        if (other.getAudiences() != null && !other.getAudiences().equals(this.getAudiences())) {
            return false;
        }
        if (other.getChannelName() == null ^ this.getChannelName() == null) {
            return false;
        }
        if (other.getChannelName() != null && !other.getChannelName().equals(this.getChannelName())) {
            return false;
        }
        if (other.getFillerSlate() == null ^ this.getFillerSlate() == null) {
            return false;
        }
        if (other.getFillerSlate() != null && !other.getFillerSlate().equals(this.getFillerSlate())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getTimeShiftConfiguration() == null ^ this.getTimeShiftConfiguration() == null) {
            return false;
        }
        return other.getTimeShiftConfiguration() == null || other.getTimeShiftConfiguration().equals(this.getTimeShiftConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAudiences() == null ? 0 : this.getAudiences().hashCode());
        hashCode = 31 * hashCode + (this.getChannelName() == null ? 0 : this.getChannelName().hashCode());
        hashCode = 31 * hashCode + (this.getFillerSlate() == null ? 0 : this.getFillerSlate().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getTimeShiftConfiguration() == null ? 0 : this.getTimeShiftConfiguration().hashCode());
        return hashCode;
    }

    public UpdateChannelRequest clone() {
        return (UpdateChannelRequest)super.clone();
    }
}

