/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mediapackagev2;

import javax.annotation.Generated;

import com.amazonaws.services.mediapackagev2.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSMediaPackageV2}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSMediaPackageV2 implements AWSMediaPackageV2 {

    protected AbstractAWSMediaPackageV2() {
    }

    @Override
    public CreateChannelResult createChannel(CreateChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateChannelGroupResult createChannelGroup(CreateChannelGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateOriginEndpointResult createOriginEndpoint(CreateOriginEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelResult deleteChannel(DeleteChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelGroupResult deleteChannelGroup(DeleteChannelGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteChannelPolicyResult deleteChannelPolicy(DeleteChannelPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteOriginEndpointResult deleteOriginEndpoint(DeleteOriginEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteOriginEndpointPolicyResult deleteOriginEndpointPolicy(DeleteOriginEndpointPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetChannelResult getChannel(GetChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetChannelGroupResult getChannelGroup(GetChannelGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetChannelPolicyResult getChannelPolicy(GetChannelPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetOriginEndpointResult getOriginEndpoint(GetOriginEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetOriginEndpointPolicyResult getOriginEndpointPolicy(GetOriginEndpointPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelGroupsResult listChannelGroups(ListChannelGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListChannelsResult listChannels(ListChannelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListOriginEndpointsResult listOriginEndpoints(ListOriginEndpointsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutChannelPolicyResult putChannelPolicy(PutChannelPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutOriginEndpointPolicyResult putOriginEndpointPolicy(PutOriginEndpointPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChannelResult updateChannel(UpdateChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateChannelGroupResult updateChannelGroup(UpdateChannelGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateOriginEndpointResult updateOriginEndpoint(UpdateOriginEndpointRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
