/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediapackagev2;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.mediapackagev2.AWSMediaPackageV2;
import com.amazonaws.services.mediapackagev2.AWSMediaPackageV2ClientBuilder;
import com.amazonaws.services.mediapackagev2.model.AWSMediaPackageV2Exception;
import com.amazonaws.services.mediapackagev2.model.CreateChannelGroupRequest;
import com.amazonaws.services.mediapackagev2.model.CreateChannelGroupResult;
import com.amazonaws.services.mediapackagev2.model.CreateChannelRequest;
import com.amazonaws.services.mediapackagev2.model.CreateChannelResult;
import com.amazonaws.services.mediapackagev2.model.CreateOriginEndpointRequest;
import com.amazonaws.services.mediapackagev2.model.CreateOriginEndpointResult;
import com.amazonaws.services.mediapackagev2.model.DeleteChannelGroupRequest;
import com.amazonaws.services.mediapackagev2.model.DeleteChannelGroupResult;
import com.amazonaws.services.mediapackagev2.model.DeleteChannelPolicyRequest;
import com.amazonaws.services.mediapackagev2.model.DeleteChannelPolicyResult;
import com.amazonaws.services.mediapackagev2.model.DeleteChannelRequest;
import com.amazonaws.services.mediapackagev2.model.DeleteChannelResult;
import com.amazonaws.services.mediapackagev2.model.DeleteOriginEndpointPolicyRequest;
import com.amazonaws.services.mediapackagev2.model.DeleteOriginEndpointPolicyResult;
import com.amazonaws.services.mediapackagev2.model.DeleteOriginEndpointRequest;
import com.amazonaws.services.mediapackagev2.model.DeleteOriginEndpointResult;
import com.amazonaws.services.mediapackagev2.model.GetChannelGroupRequest;
import com.amazonaws.services.mediapackagev2.model.GetChannelGroupResult;
import com.amazonaws.services.mediapackagev2.model.GetChannelPolicyRequest;
import com.amazonaws.services.mediapackagev2.model.GetChannelPolicyResult;
import com.amazonaws.services.mediapackagev2.model.GetChannelRequest;
import com.amazonaws.services.mediapackagev2.model.GetChannelResult;
import com.amazonaws.services.mediapackagev2.model.GetOriginEndpointPolicyRequest;
import com.amazonaws.services.mediapackagev2.model.GetOriginEndpointPolicyResult;
import com.amazonaws.services.mediapackagev2.model.GetOriginEndpointRequest;
import com.amazonaws.services.mediapackagev2.model.GetOriginEndpointResult;
import com.amazonaws.services.mediapackagev2.model.ListChannelGroupsRequest;
import com.amazonaws.services.mediapackagev2.model.ListChannelGroupsResult;
import com.amazonaws.services.mediapackagev2.model.ListChannelsRequest;
import com.amazonaws.services.mediapackagev2.model.ListChannelsResult;
import com.amazonaws.services.mediapackagev2.model.ListOriginEndpointsRequest;
import com.amazonaws.services.mediapackagev2.model.ListOriginEndpointsResult;
import com.amazonaws.services.mediapackagev2.model.ListTagsForResourceRequest;
import com.amazonaws.services.mediapackagev2.model.ListTagsForResourceResult;
import com.amazonaws.services.mediapackagev2.model.PutChannelPolicyRequest;
import com.amazonaws.services.mediapackagev2.model.PutChannelPolicyResult;
import com.amazonaws.services.mediapackagev2.model.PutOriginEndpointPolicyRequest;
import com.amazonaws.services.mediapackagev2.model.PutOriginEndpointPolicyResult;
import com.amazonaws.services.mediapackagev2.model.TagResourceRequest;
import com.amazonaws.services.mediapackagev2.model.TagResourceResult;
import com.amazonaws.services.mediapackagev2.model.UntagResourceRequest;
import com.amazonaws.services.mediapackagev2.model.UntagResourceResult;
import com.amazonaws.services.mediapackagev2.model.UpdateChannelGroupRequest;
import com.amazonaws.services.mediapackagev2.model.UpdateChannelGroupResult;
import com.amazonaws.services.mediapackagev2.model.UpdateChannelRequest;
import com.amazonaws.services.mediapackagev2.model.UpdateChannelResult;
import com.amazonaws.services.mediapackagev2.model.UpdateOriginEndpointRequest;
import com.amazonaws.services.mediapackagev2.model.UpdateOriginEndpointResult;
import com.amazonaws.services.mediapackagev2.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.CreateChannelGroupRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.CreateChannelGroupResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.CreateChannelRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.CreateChannelResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.CreateOriginEndpointRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.CreateOriginEndpointResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.DeleteChannelGroupRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.DeleteChannelGroupResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.DeleteChannelPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.DeleteChannelPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.DeleteChannelRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.DeleteChannelResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.DeleteOriginEndpointPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.DeleteOriginEndpointPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.DeleteOriginEndpointRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.DeleteOriginEndpointResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.GetChannelGroupRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.GetChannelGroupResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.GetChannelPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.GetChannelPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.GetChannelRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.GetChannelResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.GetOriginEndpointPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.GetOriginEndpointPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.GetOriginEndpointRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.GetOriginEndpointResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.ListChannelGroupsRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.ListChannelGroupsResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.ListChannelsRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.ListChannelsResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.ListOriginEndpointsRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.ListOriginEndpointsResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.PutChannelPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.PutChannelPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.PutOriginEndpointPolicyRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.PutOriginEndpointPolicyResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.UpdateChannelGroupRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.UpdateChannelGroupResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.UpdateChannelRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.UpdateChannelResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.UpdateOriginEndpointRequestProtocolMarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.UpdateOriginEndpointResultJsonUnmarshaller;
import com.amazonaws.services.mediapackagev2.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSMediaPackageV2Client
extends AmazonWebServiceClient
implements AWSMediaPackageV2 {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSMediaPackageV2.class);
    private static final String DEFAULT_SIGNING_NAME = "mediapackagev2";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSMediaPackageV2Exception.class));

    public static AWSMediaPackageV2ClientBuilder builder() {
        return AWSMediaPackageV2ClientBuilder.standard();
    }

    AWSMediaPackageV2Client(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSMediaPackageV2Client(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("mediapackagev2.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/mediapackagev2/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/mediapackagev2/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateChannelResult createChannel(CreateChannelRequest request) {
        request = (CreateChannelRequest)this.beforeClientExecution(request);
        return this.executeCreateChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateChannelResult executeCreateChannel(CreateChannelRequest createChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateChannelRequestProtocolMarshaller(protocolFactory).marshall((CreateChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)createChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateChannelResult createChannelResult = (CreateChannelResult)response.getAwsResponse();
            return createChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateChannelGroupResult createChannelGroup(CreateChannelGroupRequest request) {
        request = (CreateChannelGroupRequest)this.beforeClientExecution(request);
        return this.executeCreateChannelGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateChannelGroupResult executeCreateChannelGroup(CreateChannelGroupRequest createChannelGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createChannelGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateChannelGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateChannelGroupRequestProtocolMarshaller(protocolFactory).marshall((CreateChannelGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createChannelGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateChannelGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateChannelGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateChannelGroupResult createChannelGroupResult = (CreateChannelGroupResult)response.getAwsResponse();
            return createChannelGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateOriginEndpointResult createOriginEndpoint(CreateOriginEndpointRequest request) {
        request = (CreateOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executeCreateOriginEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateOriginEndpointResult executeCreateOriginEndpoint(CreateOriginEndpointRequest createOriginEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createOriginEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateOriginEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateOriginEndpointRequestProtocolMarshaller(protocolFactory).marshall((CreateOriginEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)createOriginEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateOriginEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateOriginEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateOriginEndpointResult createOriginEndpointResult = (CreateOriginEndpointResult)response.getAwsResponse();
            return createOriginEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteChannelResult deleteChannel(DeleteChannelRequest request) {
        request = (DeleteChannelRequest)this.beforeClientExecution(request);
        return this.executeDeleteChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteChannelResult executeDeleteChannel(DeleteChannelRequest deleteChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteChannelRequestProtocolMarshaller(protocolFactory).marshall((DeleteChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteChannelResult deleteChannelResult = (DeleteChannelResult)response.getAwsResponse();
            return deleteChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteChannelGroupResult deleteChannelGroup(DeleteChannelGroupRequest request) {
        request = (DeleteChannelGroupRequest)this.beforeClientExecution(request);
        return this.executeDeleteChannelGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteChannelGroupResult executeDeleteChannelGroup(DeleteChannelGroupRequest deleteChannelGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteChannelGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteChannelGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteChannelGroupRequestProtocolMarshaller(protocolFactory).marshall((DeleteChannelGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteChannelGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteChannelGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteChannelGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteChannelGroupResult deleteChannelGroupResult = (DeleteChannelGroupResult)response.getAwsResponse();
            return deleteChannelGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteChannelPolicyResult deleteChannelPolicy(DeleteChannelPolicyRequest request) {
        request = (DeleteChannelPolicyRequest)this.beforeClientExecution(request);
        return this.executeDeleteChannelPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteChannelPolicyResult executeDeleteChannelPolicy(DeleteChannelPolicyRequest deleteChannelPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteChannelPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteChannelPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteChannelPolicyRequestProtocolMarshaller(protocolFactory).marshall((DeleteChannelPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteChannelPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteChannelPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteChannelPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteChannelPolicyResult deleteChannelPolicyResult = (DeleteChannelPolicyResult)response.getAwsResponse();
            return deleteChannelPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteOriginEndpointResult deleteOriginEndpoint(DeleteOriginEndpointRequest request) {
        request = (DeleteOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executeDeleteOriginEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteOriginEndpointResult executeDeleteOriginEndpoint(DeleteOriginEndpointRequest deleteOriginEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteOriginEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteOriginEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteOriginEndpointRequestProtocolMarshaller(protocolFactory).marshall((DeleteOriginEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteOriginEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteOriginEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteOriginEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteOriginEndpointResult deleteOriginEndpointResult = (DeleteOriginEndpointResult)response.getAwsResponse();
            return deleteOriginEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteOriginEndpointPolicyResult deleteOriginEndpointPolicy(DeleteOriginEndpointPolicyRequest request) {
        request = (DeleteOriginEndpointPolicyRequest)this.beforeClientExecution(request);
        return this.executeDeleteOriginEndpointPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteOriginEndpointPolicyResult executeDeleteOriginEndpointPolicy(DeleteOriginEndpointPolicyRequest deleteOriginEndpointPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteOriginEndpointPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteOriginEndpointPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteOriginEndpointPolicyRequestProtocolMarshaller(protocolFactory).marshall((DeleteOriginEndpointPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteOriginEndpointPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteOriginEndpointPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteOriginEndpointPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteOriginEndpointPolicyResult deleteOriginEndpointPolicyResult = (DeleteOriginEndpointPolicyResult)response.getAwsResponse();
            return deleteOriginEndpointPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetChannelResult getChannel(GetChannelRequest request) {
        request = (GetChannelRequest)this.beforeClientExecution(request);
        return this.executeGetChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetChannelResult executeGetChannel(GetChannelRequest getChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetChannelRequestProtocolMarshaller(protocolFactory).marshall((GetChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)getChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetChannelResult getChannelResult = (GetChannelResult)response.getAwsResponse();
            return getChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetChannelGroupResult getChannelGroup(GetChannelGroupRequest request) {
        request = (GetChannelGroupRequest)this.beforeClientExecution(request);
        return this.executeGetChannelGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetChannelGroupResult executeGetChannelGroup(GetChannelGroupRequest getChannelGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getChannelGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetChannelGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetChannelGroupRequestProtocolMarshaller(protocolFactory).marshall((GetChannelGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)getChannelGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetChannelGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetChannelGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetChannelGroupResult getChannelGroupResult = (GetChannelGroupResult)response.getAwsResponse();
            return getChannelGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetChannelPolicyResult getChannelPolicy(GetChannelPolicyRequest request) {
        request = (GetChannelPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetChannelPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetChannelPolicyResult executeGetChannelPolicy(GetChannelPolicyRequest getChannelPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getChannelPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetChannelPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetChannelPolicyRequestProtocolMarshaller(protocolFactory).marshall((GetChannelPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getChannelPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetChannelPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetChannelPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetChannelPolicyResult getChannelPolicyResult = (GetChannelPolicyResult)response.getAwsResponse();
            return getChannelPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetOriginEndpointResult getOriginEndpoint(GetOriginEndpointRequest request) {
        request = (GetOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executeGetOriginEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetOriginEndpointResult executeGetOriginEndpoint(GetOriginEndpointRequest getOriginEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOriginEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOriginEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOriginEndpointRequestProtocolMarshaller(protocolFactory).marshall((GetOriginEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)getOriginEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetOriginEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetOriginEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetOriginEndpointResult getOriginEndpointResult = (GetOriginEndpointResult)response.getAwsResponse();
            return getOriginEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetOriginEndpointPolicyResult getOriginEndpointPolicy(GetOriginEndpointPolicyRequest request) {
        request = (GetOriginEndpointPolicyRequest)this.beforeClientExecution(request);
        return this.executeGetOriginEndpointPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetOriginEndpointPolicyResult executeGetOriginEndpointPolicy(GetOriginEndpointPolicyRequest getOriginEndpointPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOriginEndpointPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOriginEndpointPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOriginEndpointPolicyRequestProtocolMarshaller(protocolFactory).marshall((GetOriginEndpointPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getOriginEndpointPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetOriginEndpointPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetOriginEndpointPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetOriginEndpointPolicyResult getOriginEndpointPolicyResult = (GetOriginEndpointPolicyResult)response.getAwsResponse();
            return getOriginEndpointPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListChannelGroupsResult listChannelGroups(ListChannelGroupsRequest request) {
        request = (ListChannelGroupsRequest)this.beforeClientExecution(request);
        return this.executeListChannelGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListChannelGroupsResult executeListChannelGroups(ListChannelGroupsRequest listChannelGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listChannelGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListChannelGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListChannelGroupsRequestProtocolMarshaller(protocolFactory).marshall((ListChannelGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listChannelGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListChannelGroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListChannelGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListChannelGroupsResult listChannelGroupsResult = (ListChannelGroupsResult)response.getAwsResponse();
            return listChannelGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListChannelsResult listChannels(ListChannelsRequest request) {
        request = (ListChannelsRequest)this.beforeClientExecution(request);
        return this.executeListChannels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListChannelsResult executeListChannels(ListChannelsRequest listChannelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listChannelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListChannelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListChannelsRequestProtocolMarshaller(protocolFactory).marshall((ListChannelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listChannelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListChannels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListChannelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListChannelsResult listChannelsResult = (ListChannelsResult)response.getAwsResponse();
            return listChannelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListOriginEndpointsResult listOriginEndpoints(ListOriginEndpointsRequest request) {
        request = (ListOriginEndpointsRequest)this.beforeClientExecution(request);
        return this.executeListOriginEndpoints(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListOriginEndpointsResult executeListOriginEndpoints(ListOriginEndpointsRequest listOriginEndpointsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listOriginEndpointsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListOriginEndpointsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListOriginEndpointsRequestProtocolMarshaller(protocolFactory).marshall((ListOriginEndpointsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listOriginEndpointsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListOriginEndpoints");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListOriginEndpointsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListOriginEndpointsResult listOriginEndpointsResult = (ListOriginEndpointsResult)response.getAwsResponse();
            return listOriginEndpointsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutChannelPolicyResult putChannelPolicy(PutChannelPolicyRequest request) {
        request = (PutChannelPolicyRequest)this.beforeClientExecution(request);
        return this.executePutChannelPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutChannelPolicyResult executePutChannelPolicy(PutChannelPolicyRequest putChannelPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putChannelPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutChannelPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutChannelPolicyRequestProtocolMarshaller(protocolFactory).marshall((PutChannelPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putChannelPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutChannelPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutChannelPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutChannelPolicyResult putChannelPolicyResult = (PutChannelPolicyResult)response.getAwsResponse();
            return putChannelPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutOriginEndpointPolicyResult putOriginEndpointPolicy(PutOriginEndpointPolicyRequest request) {
        request = (PutOriginEndpointPolicyRequest)this.beforeClientExecution(request);
        return this.executePutOriginEndpointPolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutOriginEndpointPolicyResult executePutOriginEndpointPolicy(PutOriginEndpointPolicyRequest putOriginEndpointPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putOriginEndpointPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutOriginEndpointPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutOriginEndpointPolicyRequestProtocolMarshaller(protocolFactory).marshall((PutOriginEndpointPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putOriginEndpointPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutOriginEndpointPolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutOriginEndpointPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutOriginEndpointPolicyResult putOriginEndpointPolicyResult = (PutOriginEndpointPolicyResult)response.getAwsResponse();
            return putOriginEndpointPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateChannelResult updateChannel(UpdateChannelRequest request) {
        request = (UpdateChannelRequest)this.beforeClientExecution(request);
        return this.executeUpdateChannel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateChannelResult executeUpdateChannel(UpdateChannelRequest updateChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateChannelRequestProtocolMarshaller(protocolFactory).marshall((UpdateChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateChannel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateChannelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateChannelResult updateChannelResult = (UpdateChannelResult)response.getAwsResponse();
            return updateChannelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateChannelGroupResult updateChannelGroup(UpdateChannelGroupRequest request) {
        request = (UpdateChannelGroupRequest)this.beforeClientExecution(request);
        return this.executeUpdateChannelGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateChannelGroupResult executeUpdateChannelGroup(UpdateChannelGroupRequest updateChannelGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateChannelGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateChannelGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateChannelGroupRequestProtocolMarshaller(protocolFactory).marshall((UpdateChannelGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateChannelGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateChannelGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateChannelGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateChannelGroupResult updateChannelGroupResult = (UpdateChannelGroupResult)response.getAwsResponse();
            return updateChannelGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateOriginEndpointResult updateOriginEndpoint(UpdateOriginEndpointRequest request) {
        request = (UpdateOriginEndpointRequest)this.beforeClientExecution(request);
        return this.executeUpdateOriginEndpoint(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateOriginEndpointResult executeUpdateOriginEndpoint(UpdateOriginEndpointRequest updateOriginEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateOriginEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateOriginEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateOriginEndpointRequestProtocolMarshaller(protocolFactory).marshall((UpdateOriginEndpointRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateOriginEndpointRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"MediaPackageV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateOriginEndpoint");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateOriginEndpointResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateOriginEndpointResult updateOriginEndpointResult = (UpdateOriginEndpointResult)response.getAwsResponse();
            return updateOriginEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

