/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.CreateInputRequest;
import com.amazonaws.util.IdempotentUtils;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class CreateInputRequestMarshaller {
    private static final MarshallingInfo<List> DESTINATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinations").build();
    private static final MarshallingInfo<List> INPUTDEVICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputDevices").build();
    private static final MarshallingInfo<List> INPUTSECURITYGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inputSecurityGroups").build();
    private static final MarshallingInfo<List> MEDIACONNECTFLOWS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mediaConnectFlows").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> REQUESTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestId").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<List> SOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sources").build();
    private static final MarshallingInfo<Map> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").build();
    private static final MarshallingInfo<StructuredPojo> VPC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vpc").build();
    private static final MarshallingInfo<StructuredPojo> SRTSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("srtSettings").build();
    private static final CreateInputRequestMarshaller instance = new CreateInputRequestMarshaller();

    public static CreateInputRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(CreateInputRequest createInputRequest, ProtocolMarshaller protocolMarshaller) {
        if (createInputRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(createInputRequest.getDestinations(), DESTINATIONS_BINDING);
            protocolMarshaller.marshall(createInputRequest.getInputDevices(), INPUTDEVICES_BINDING);
            protocolMarshaller.marshall(createInputRequest.getInputSecurityGroups(), INPUTSECURITYGROUPS_BINDING);
            protocolMarshaller.marshall(createInputRequest.getMediaConnectFlows(), MEDIACONNECTFLOWS_BINDING);
            protocolMarshaller.marshall((Object)createInputRequest.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createInputRequest.getRequestId(), REQUESTID_BINDING);
            protocolMarshaller.marshall((Object)createInputRequest.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(createInputRequest.getSources(), SOURCES_BINDING);
            protocolMarshaller.marshall(createInputRequest.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)createInputRequest.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)createInputRequest.getVpc(), VPC_BINDING);
            protocolMarshaller.marshall((Object)createInputRequest.getSrtSettings(), SRTSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

