/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.DeviceSettingsSyncState;
import com.amazonaws.services.medialive.model.DeviceUpdateStatus;
import com.amazonaws.services.medialive.model.InputDeviceConnectionState;
import com.amazonaws.services.medialive.model.InputDeviceHdSettings;
import com.amazonaws.services.medialive.model.InputDeviceNetworkSettings;
import com.amazonaws.services.medialive.model.InputDeviceOutputType;
import com.amazonaws.services.medialive.model.InputDeviceType;
import com.amazonaws.services.medialive.model.InputDeviceUhdSettings;
import com.amazonaws.services.medialive.model.transform.InputDeviceSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InputDeviceSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private String connectionState;
    private String deviceSettingsSyncState;
    private String deviceUpdateStatus;
    private InputDeviceHdSettings hdDeviceSettings;
    private String id;
    private String macAddress;
    private String name;
    private InputDeviceNetworkSettings networkSettings;
    private String serialNumber;
    private String type;
    private InputDeviceUhdSettings uhdDeviceSettings;
    private Map<String, String> tags;
    private String availabilityZone;
    private List<String> medialiveInputArns;
    private String outputType;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public InputDeviceSummary withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setConnectionState(String connectionState) {
        this.connectionState = connectionState;
    }

    public String getConnectionState() {
        return this.connectionState;
    }

    public InputDeviceSummary withConnectionState(String connectionState) {
        this.setConnectionState(connectionState);
        return this;
    }

    public InputDeviceSummary withConnectionState(InputDeviceConnectionState connectionState) {
        this.connectionState = connectionState.toString();
        return this;
    }

    public void setDeviceSettingsSyncState(String deviceSettingsSyncState) {
        this.deviceSettingsSyncState = deviceSettingsSyncState;
    }

    public String getDeviceSettingsSyncState() {
        return this.deviceSettingsSyncState;
    }

    public InputDeviceSummary withDeviceSettingsSyncState(String deviceSettingsSyncState) {
        this.setDeviceSettingsSyncState(deviceSettingsSyncState);
        return this;
    }

    public InputDeviceSummary withDeviceSettingsSyncState(DeviceSettingsSyncState deviceSettingsSyncState) {
        this.deviceSettingsSyncState = deviceSettingsSyncState.toString();
        return this;
    }

    public void setDeviceUpdateStatus(String deviceUpdateStatus) {
        this.deviceUpdateStatus = deviceUpdateStatus;
    }

    public String getDeviceUpdateStatus() {
        return this.deviceUpdateStatus;
    }

    public InputDeviceSummary withDeviceUpdateStatus(String deviceUpdateStatus) {
        this.setDeviceUpdateStatus(deviceUpdateStatus);
        return this;
    }

    public InputDeviceSummary withDeviceUpdateStatus(DeviceUpdateStatus deviceUpdateStatus) {
        this.deviceUpdateStatus = deviceUpdateStatus.toString();
        return this;
    }

    public void setHdDeviceSettings(InputDeviceHdSettings hdDeviceSettings) {
        this.hdDeviceSettings = hdDeviceSettings;
    }

    public InputDeviceHdSettings getHdDeviceSettings() {
        return this.hdDeviceSettings;
    }

    public InputDeviceSummary withHdDeviceSettings(InputDeviceHdSettings hdDeviceSettings) {
        this.setHdDeviceSettings(hdDeviceSettings);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public InputDeviceSummary withId(String id) {
        this.setId(id);
        return this;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public InputDeviceSummary withMacAddress(String macAddress) {
        this.setMacAddress(macAddress);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public InputDeviceSummary withName(String name) {
        this.setName(name);
        return this;
    }

    public void setNetworkSettings(InputDeviceNetworkSettings networkSettings) {
        this.networkSettings = networkSettings;
    }

    public InputDeviceNetworkSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public InputDeviceSummary withNetworkSettings(InputDeviceNetworkSettings networkSettings) {
        this.setNetworkSettings(networkSettings);
        return this;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public InputDeviceSummary withSerialNumber(String serialNumber) {
        this.setSerialNumber(serialNumber);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public InputDeviceSummary withType(String type) {
        this.setType(type);
        return this;
    }

    public InputDeviceSummary withType(InputDeviceType type) {
        this.type = type.toString();
        return this;
    }

    public void setUhdDeviceSettings(InputDeviceUhdSettings uhdDeviceSettings) {
        this.uhdDeviceSettings = uhdDeviceSettings;
    }

    public InputDeviceUhdSettings getUhdDeviceSettings() {
        return this.uhdDeviceSettings;
    }

    public InputDeviceSummary withUhdDeviceSettings(InputDeviceUhdSettings uhdDeviceSettings) {
        this.setUhdDeviceSettings(uhdDeviceSettings);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public InputDeviceSummary withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public InputDeviceSummary addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public InputDeviceSummary clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public InputDeviceSummary withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public List<String> getMedialiveInputArns() {
        return this.medialiveInputArns;
    }

    public void setMedialiveInputArns(Collection<String> medialiveInputArns) {
        if (medialiveInputArns == null) {
            this.medialiveInputArns = null;
            return;
        }
        this.medialiveInputArns = new ArrayList<String>(medialiveInputArns);
    }

    public InputDeviceSummary withMedialiveInputArns(String ... medialiveInputArns) {
        if (this.medialiveInputArns == null) {
            this.setMedialiveInputArns(new ArrayList<String>(medialiveInputArns.length));
        }
        for (String ele : medialiveInputArns) {
            this.medialiveInputArns.add(ele);
        }
        return this;
    }

    public InputDeviceSummary withMedialiveInputArns(Collection<String> medialiveInputArns) {
        this.setMedialiveInputArns(medialiveInputArns);
        return this;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public InputDeviceSummary withOutputType(String outputType) {
        this.setOutputType(outputType);
        return this;
    }

    public InputDeviceSummary withOutputType(InputDeviceOutputType outputType) {
        this.outputType = outputType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getConnectionState() != null) {
            sb.append("ConnectionState: ").append(this.getConnectionState()).append(",");
        }
        if (this.getDeviceSettingsSyncState() != null) {
            sb.append("DeviceSettingsSyncState: ").append(this.getDeviceSettingsSyncState()).append(",");
        }
        if (this.getDeviceUpdateStatus() != null) {
            sb.append("DeviceUpdateStatus: ").append(this.getDeviceUpdateStatus()).append(",");
        }
        if (this.getHdDeviceSettings() != null) {
            sb.append("HdDeviceSettings: ").append(this.getHdDeviceSettings()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getMacAddress() != null) {
            sb.append("MacAddress: ").append(this.getMacAddress()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getNetworkSettings() != null) {
            sb.append("NetworkSettings: ").append(this.getNetworkSettings()).append(",");
        }
        if (this.getSerialNumber() != null) {
            sb.append("SerialNumber: ").append(this.getSerialNumber()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getUhdDeviceSettings() != null) {
            sb.append("UhdDeviceSettings: ").append(this.getUhdDeviceSettings()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getMedialiveInputArns() != null) {
            sb.append("MedialiveInputArns: ").append(this.getMedialiveInputArns()).append(",");
        }
        if (this.getOutputType() != null) {
            sb.append("OutputType: ").append(this.getOutputType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceSummary)) {
            return false;
        }
        InputDeviceSummary other = (InputDeviceSummary)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getConnectionState() == null ^ this.getConnectionState() == null) {
            return false;
        }
        if (other.getConnectionState() != null && !other.getConnectionState().equals(this.getConnectionState())) {
            return false;
        }
        if (other.getDeviceSettingsSyncState() == null ^ this.getDeviceSettingsSyncState() == null) {
            return false;
        }
        if (other.getDeviceSettingsSyncState() != null && !other.getDeviceSettingsSyncState().equals(this.getDeviceSettingsSyncState())) {
            return false;
        }
        if (other.getDeviceUpdateStatus() == null ^ this.getDeviceUpdateStatus() == null) {
            return false;
        }
        if (other.getDeviceUpdateStatus() != null && !other.getDeviceUpdateStatus().equals(this.getDeviceUpdateStatus())) {
            return false;
        }
        if (other.getHdDeviceSettings() == null ^ this.getHdDeviceSettings() == null) {
            return false;
        }
        if (other.getHdDeviceSettings() != null && !other.getHdDeviceSettings().equals(this.getHdDeviceSettings())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getMacAddress() == null ^ this.getMacAddress() == null) {
            return false;
        }
        if (other.getMacAddress() != null && !other.getMacAddress().equals(this.getMacAddress())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getNetworkSettings() == null ^ this.getNetworkSettings() == null) {
            return false;
        }
        if (other.getNetworkSettings() != null && !other.getNetworkSettings().equals(this.getNetworkSettings())) {
            return false;
        }
        if (other.getSerialNumber() == null ^ this.getSerialNumber() == null) {
            return false;
        }
        if (other.getSerialNumber() != null && !other.getSerialNumber().equals(this.getSerialNumber())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getUhdDeviceSettings() == null ^ this.getUhdDeviceSettings() == null) {
            return false;
        }
        if (other.getUhdDeviceSettings() != null && !other.getUhdDeviceSettings().equals(this.getUhdDeviceSettings())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getMedialiveInputArns() == null ^ this.getMedialiveInputArns() == null) {
            return false;
        }
        if (other.getMedialiveInputArns() != null && !other.getMedialiveInputArns().equals(this.getMedialiveInputArns())) {
            return false;
        }
        if (other.getOutputType() == null ^ this.getOutputType() == null) {
            return false;
        }
        return other.getOutputType() == null || other.getOutputType().equals(this.getOutputType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getConnectionState() == null ? 0 : this.getConnectionState().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceSettingsSyncState() == null ? 0 : this.getDeviceSettingsSyncState().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceUpdateStatus() == null ? 0 : this.getDeviceUpdateStatus().hashCode());
        hashCode = 31 * hashCode + (this.getHdDeviceSettings() == null ? 0 : this.getHdDeviceSettings().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getMacAddress() == null ? 0 : this.getMacAddress().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkSettings() == null ? 0 : this.getNetworkSettings().hashCode());
        hashCode = 31 * hashCode + (this.getSerialNumber() == null ? 0 : this.getSerialNumber().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getUhdDeviceSettings() == null ? 0 : this.getUhdDeviceSettings().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getMedialiveInputArns() == null ? 0 : this.getMedialiveInputArns().hashCode());
        hashCode = 31 * hashCode + (this.getOutputType() == null ? 0 : this.getOutputType().hashCode());
        return hashCode;
    }

    public InputDeviceSummary clone() {
        try {
            return (InputDeviceSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputDeviceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

