/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.medialive.model.InputDeviceActiveInput;
import com.amazonaws.services.medialive.model.InputDeviceCodec;
import com.amazonaws.services.medialive.model.InputDeviceConfiguredInput;
import com.amazonaws.services.medialive.model.InputDeviceMediaConnectSettings;
import com.amazonaws.services.medialive.model.InputDeviceScanType;
import com.amazonaws.services.medialive.model.InputDeviceState;
import com.amazonaws.services.medialive.model.InputDeviceUhdAudioChannelPairConfig;
import com.amazonaws.services.medialive.model.transform.InputDeviceUhdSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InputDeviceUhdSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private String activeInput;
    private String configuredInput;
    private String deviceState;
    private Double framerate;
    private Integer height;
    private Integer maxBitrate;
    private String scanType;
    private Integer width;
    private Integer latencyMs;
    private String codec;
    private InputDeviceMediaConnectSettings mediaconnectSettings;
    private List<InputDeviceUhdAudioChannelPairConfig> audioChannelPairs;

    public void setActiveInput(String activeInput) {
        this.activeInput = activeInput;
    }

    public String getActiveInput() {
        return this.activeInput;
    }

    public InputDeviceUhdSettings withActiveInput(String activeInput) {
        this.setActiveInput(activeInput);
        return this;
    }

    public InputDeviceUhdSettings withActiveInput(InputDeviceActiveInput activeInput) {
        this.activeInput = activeInput.toString();
        return this;
    }

    public void setConfiguredInput(String configuredInput) {
        this.configuredInput = configuredInput;
    }

    public String getConfiguredInput() {
        return this.configuredInput;
    }

    public InputDeviceUhdSettings withConfiguredInput(String configuredInput) {
        this.setConfiguredInput(configuredInput);
        return this;
    }

    public InputDeviceUhdSettings withConfiguredInput(InputDeviceConfiguredInput configuredInput) {
        this.configuredInput = configuredInput.toString();
        return this;
    }

    public void setDeviceState(String deviceState) {
        this.deviceState = deviceState;
    }

    public String getDeviceState() {
        return this.deviceState;
    }

    public InputDeviceUhdSettings withDeviceState(String deviceState) {
        this.setDeviceState(deviceState);
        return this;
    }

    public InputDeviceUhdSettings withDeviceState(InputDeviceState deviceState) {
        this.deviceState = deviceState.toString();
        return this;
    }

    public void setFramerate(Double framerate) {
        this.framerate = framerate;
    }

    public Double getFramerate() {
        return this.framerate;
    }

    public InputDeviceUhdSettings withFramerate(Double framerate) {
        this.setFramerate(framerate);
        return this;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getHeight() {
        return this.height;
    }

    public InputDeviceUhdSettings withHeight(Integer height) {
        this.setHeight(height);
        return this;
    }

    public void setMaxBitrate(Integer maxBitrate) {
        this.maxBitrate = maxBitrate;
    }

    public Integer getMaxBitrate() {
        return this.maxBitrate;
    }

    public InputDeviceUhdSettings withMaxBitrate(Integer maxBitrate) {
        this.setMaxBitrate(maxBitrate);
        return this;
    }

    public void setScanType(String scanType) {
        this.scanType = scanType;
    }

    public String getScanType() {
        return this.scanType;
    }

    public InputDeviceUhdSettings withScanType(String scanType) {
        this.setScanType(scanType);
        return this;
    }

    public InputDeviceUhdSettings withScanType(InputDeviceScanType scanType) {
        this.scanType = scanType.toString();
        return this;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getWidth() {
        return this.width;
    }

    public InputDeviceUhdSettings withWidth(Integer width) {
        this.setWidth(width);
        return this;
    }

    public void setLatencyMs(Integer latencyMs) {
        this.latencyMs = latencyMs;
    }

    public Integer getLatencyMs() {
        return this.latencyMs;
    }

    public InputDeviceUhdSettings withLatencyMs(Integer latencyMs) {
        this.setLatencyMs(latencyMs);
        return this;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public String getCodec() {
        return this.codec;
    }

    public InputDeviceUhdSettings withCodec(String codec) {
        this.setCodec(codec);
        return this;
    }

    public InputDeviceUhdSettings withCodec(InputDeviceCodec codec) {
        this.codec = codec.toString();
        return this;
    }

    public void setMediaconnectSettings(InputDeviceMediaConnectSettings mediaconnectSettings) {
        this.mediaconnectSettings = mediaconnectSettings;
    }

    public InputDeviceMediaConnectSettings getMediaconnectSettings() {
        return this.mediaconnectSettings;
    }

    public InputDeviceUhdSettings withMediaconnectSettings(InputDeviceMediaConnectSettings mediaconnectSettings) {
        this.setMediaconnectSettings(mediaconnectSettings);
        return this;
    }

    public List<InputDeviceUhdAudioChannelPairConfig> getAudioChannelPairs() {
        return this.audioChannelPairs;
    }

    public void setAudioChannelPairs(Collection<InputDeviceUhdAudioChannelPairConfig> audioChannelPairs) {
        if (audioChannelPairs == null) {
            this.audioChannelPairs = null;
            return;
        }
        this.audioChannelPairs = new ArrayList<InputDeviceUhdAudioChannelPairConfig>(audioChannelPairs);
    }

    public InputDeviceUhdSettings withAudioChannelPairs(InputDeviceUhdAudioChannelPairConfig ... audioChannelPairs) {
        if (this.audioChannelPairs == null) {
            this.setAudioChannelPairs(new ArrayList<InputDeviceUhdAudioChannelPairConfig>(audioChannelPairs.length));
        }
        for (InputDeviceUhdAudioChannelPairConfig ele : audioChannelPairs) {
            this.audioChannelPairs.add(ele);
        }
        return this;
    }

    public InputDeviceUhdSettings withAudioChannelPairs(Collection<InputDeviceUhdAudioChannelPairConfig> audioChannelPairs) {
        this.setAudioChannelPairs(audioChannelPairs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActiveInput() != null) {
            sb.append("ActiveInput: ").append(this.getActiveInput()).append(",");
        }
        if (this.getConfiguredInput() != null) {
            sb.append("ConfiguredInput: ").append(this.getConfiguredInput()).append(",");
        }
        if (this.getDeviceState() != null) {
            sb.append("DeviceState: ").append(this.getDeviceState()).append(",");
        }
        if (this.getFramerate() != null) {
            sb.append("Framerate: ").append(this.getFramerate()).append(",");
        }
        if (this.getHeight() != null) {
            sb.append("Height: ").append(this.getHeight()).append(",");
        }
        if (this.getMaxBitrate() != null) {
            sb.append("MaxBitrate: ").append(this.getMaxBitrate()).append(",");
        }
        if (this.getScanType() != null) {
            sb.append("ScanType: ").append(this.getScanType()).append(",");
        }
        if (this.getWidth() != null) {
            sb.append("Width: ").append(this.getWidth()).append(",");
        }
        if (this.getLatencyMs() != null) {
            sb.append("LatencyMs: ").append(this.getLatencyMs()).append(",");
        }
        if (this.getCodec() != null) {
            sb.append("Codec: ").append(this.getCodec()).append(",");
        }
        if (this.getMediaconnectSettings() != null) {
            sb.append("MediaconnectSettings: ").append(this.getMediaconnectSettings()).append(",");
        }
        if (this.getAudioChannelPairs() != null) {
            sb.append("AudioChannelPairs: ").append(this.getAudioChannelPairs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceUhdSettings)) {
            return false;
        }
        InputDeviceUhdSettings other = (InputDeviceUhdSettings)obj;
        if (other.getActiveInput() == null ^ this.getActiveInput() == null) {
            return false;
        }
        if (other.getActiveInput() != null && !other.getActiveInput().equals(this.getActiveInput())) {
            return false;
        }
        if (other.getConfiguredInput() == null ^ this.getConfiguredInput() == null) {
            return false;
        }
        if (other.getConfiguredInput() != null && !other.getConfiguredInput().equals(this.getConfiguredInput())) {
            return false;
        }
        if (other.getDeviceState() == null ^ this.getDeviceState() == null) {
            return false;
        }
        if (other.getDeviceState() != null && !other.getDeviceState().equals(this.getDeviceState())) {
            return false;
        }
        if (other.getFramerate() == null ^ this.getFramerate() == null) {
            return false;
        }
        if (other.getFramerate() != null && !other.getFramerate().equals(this.getFramerate())) {
            return false;
        }
        if (other.getHeight() == null ^ this.getHeight() == null) {
            return false;
        }
        if (other.getHeight() != null && !other.getHeight().equals(this.getHeight())) {
            return false;
        }
        if (other.getMaxBitrate() == null ^ this.getMaxBitrate() == null) {
            return false;
        }
        if (other.getMaxBitrate() != null && !other.getMaxBitrate().equals(this.getMaxBitrate())) {
            return false;
        }
        if (other.getScanType() == null ^ this.getScanType() == null) {
            return false;
        }
        if (other.getScanType() != null && !other.getScanType().equals(this.getScanType())) {
            return false;
        }
        if (other.getWidth() == null ^ this.getWidth() == null) {
            return false;
        }
        if (other.getWidth() != null && !other.getWidth().equals(this.getWidth())) {
            return false;
        }
        if (other.getLatencyMs() == null ^ this.getLatencyMs() == null) {
            return false;
        }
        if (other.getLatencyMs() != null && !other.getLatencyMs().equals(this.getLatencyMs())) {
            return false;
        }
        if (other.getCodec() == null ^ this.getCodec() == null) {
            return false;
        }
        if (other.getCodec() != null && !other.getCodec().equals(this.getCodec())) {
            return false;
        }
        if (other.getMediaconnectSettings() == null ^ this.getMediaconnectSettings() == null) {
            return false;
        }
        if (other.getMediaconnectSettings() != null && !other.getMediaconnectSettings().equals(this.getMediaconnectSettings())) {
            return false;
        }
        if (other.getAudioChannelPairs() == null ^ this.getAudioChannelPairs() == null) {
            return false;
        }
        return other.getAudioChannelPairs() == null || other.getAudioChannelPairs().equals(this.getAudioChannelPairs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActiveInput() == null ? 0 : this.getActiveInput().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguredInput() == null ? 0 : this.getConfiguredInput().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceState() == null ? 0 : this.getDeviceState().hashCode());
        hashCode = 31 * hashCode + (this.getFramerate() == null ? 0 : this.getFramerate().hashCode());
        hashCode = 31 * hashCode + (this.getHeight() == null ? 0 : this.getHeight().hashCode());
        hashCode = 31 * hashCode + (this.getMaxBitrate() == null ? 0 : this.getMaxBitrate().hashCode());
        hashCode = 31 * hashCode + (this.getScanType() == null ? 0 : this.getScanType().hashCode());
        hashCode = 31 * hashCode + (this.getWidth() == null ? 0 : this.getWidth().hashCode());
        hashCode = 31 * hashCode + (this.getLatencyMs() == null ? 0 : this.getLatencyMs().hashCode());
        hashCode = 31 * hashCode + (this.getCodec() == null ? 0 : this.getCodec().hashCode());
        hashCode = 31 * hashCode + (this.getMediaconnectSettings() == null ? 0 : this.getMediaconnectSettings().hashCode());
        hashCode = 31 * hashCode + (this.getAudioChannelPairs() == null ? 0 : this.getAudioChannelPairs().hashCode());
        return hashCode;
    }

    public InputDeviceUhdSettings clone() {
        try {
            return (InputDeviceUhdSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputDeviceUhdSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

