/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.medialive.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * List of account configuration parameters to update.
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/UpdateAccountConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateAccountConfigurationRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    private AccountConfiguration accountConfiguration;

    /**
     * @param accountConfiguration
     */

    public void setAccountConfiguration(AccountConfiguration accountConfiguration) {
        this.accountConfiguration = accountConfiguration;
    }

    /**
     * @return
     */

    public AccountConfiguration getAccountConfiguration() {
        return this.accountConfiguration;
    }

    /**
     * @param accountConfiguration
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateAccountConfigurationRequest withAccountConfiguration(AccountConfiguration accountConfiguration) {
        setAccountConfiguration(accountConfiguration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAccountConfiguration() != null)
            sb.append("AccountConfiguration: ").append(getAccountConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateAccountConfigurationRequest == false)
            return false;
        UpdateAccountConfigurationRequest other = (UpdateAccountConfigurationRequest) obj;
        if (other.getAccountConfiguration() == null ^ this.getAccountConfiguration() == null)
            return false;
        if (other.getAccountConfiguration() != null && other.getAccountConfiguration().equals(this.getAccountConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAccountConfiguration() == null) ? 0 : getAccountConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public UpdateAccountConfigurationRequest clone() {
        return (UpdateAccountConfigurationRequest) super.clone();
    }

}
