/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediaconnect.model.Encryption;

@SdkInternalApi
public class EncryptionMarshaller {
    private static final MarshallingInfo<String> ALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("algorithm").build();
    private static final MarshallingInfo<String> KEYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyType").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<String> SECRETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("secretArn").build();
    private static final EncryptionMarshaller instance = new EncryptionMarshaller();

    public static EncryptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Encryption encryption, ProtocolMarshaller protocolMarshaller) {
        if (encryption == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)encryption.getAlgorithm(), ALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)encryption.getKeyType(), KEYTYPE_BINDING);
            protocolMarshaller.marshall((Object)encryption.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)encryption.getSecretArn(), SECRETARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

