/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacemetering.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.marketplacemetering.model.MeterUsageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class MeterUsageRequestMarshaller
implements Marshaller<Request<MeterUsageRequest>, MeterUsageRequest> {
    public Request<MeterUsageRequest> marshall(MeterUsageRequest meterUsageRequest) {
        if (meterUsageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)meterUsageRequest, "AWSMarketplaceMetering");
        request.addHeader("X-Amz-Target", "AWSMPMeteringService.MeterUsage");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (meterUsageRequest.getProductCode() != null) {
                jsonGenerator.writeFieldName("ProductCode").writeValue(meterUsageRequest.getProductCode());
            }
            if (meterUsageRequest.getTimestamp() != null) {
                jsonGenerator.writeFieldName("Timestamp").writeValue(meterUsageRequest.getTimestamp());
            }
            if (meterUsageRequest.getUsageDimension() != null) {
                jsonGenerator.writeFieldName("UsageDimension").writeValue(meterUsageRequest.getUsageDimension());
            }
            if (meterUsageRequest.getUsageQuantity() != null) {
                jsonGenerator.writeFieldName("UsageQuantity").writeValue((long)meterUsageRequest.getUsageQuantity().intValue());
            }
            if (meterUsageRequest.getDryRun() != null) {
                jsonGenerator.writeFieldName("DryRun").writeValue(meterUsageRequest.getDryRun().booleanValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

