/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedgrafana.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.managedgrafana.model.AuthenticationSummary;
import com.amazonaws.services.managedgrafana.model.NotificationDestinationType;
import com.amazonaws.services.managedgrafana.model.WorkspaceStatus;
import com.amazonaws.services.managedgrafana.model.transform.WorkspaceSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkspaceSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private AuthenticationSummary authentication;
    private Date created;
    private String description;
    private String endpoint;
    private String grafanaVersion;
    private String id;
    private Date modified;
    private String name;
    private List<String> notificationDestinations;
    private String status;
    private Map<String, String> tags;

    public void setAuthentication(AuthenticationSummary authentication) {
        this.authentication = authentication;
    }

    public AuthenticationSummary getAuthentication() {
        return this.authentication;
    }

    public WorkspaceSummary withAuthentication(AuthenticationSummary authentication) {
        this.setAuthentication(authentication);
        return this;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getCreated() {
        return this.created;
    }

    public WorkspaceSummary withCreated(Date created) {
        this.setCreated(created);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public WorkspaceSummary withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public WorkspaceSummary withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public void setGrafanaVersion(String grafanaVersion) {
        this.grafanaVersion = grafanaVersion;
    }

    public String getGrafanaVersion() {
        return this.grafanaVersion;
    }

    public WorkspaceSummary withGrafanaVersion(String grafanaVersion) {
        this.setGrafanaVersion(grafanaVersion);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public WorkspaceSummary withId(String id) {
        this.setId(id);
        return this;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public Date getModified() {
        return this.modified;
    }

    public WorkspaceSummary withModified(Date modified) {
        this.setModified(modified);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public WorkspaceSummary withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getNotificationDestinations() {
        return this.notificationDestinations;
    }

    public void setNotificationDestinations(Collection<String> notificationDestinations) {
        if (notificationDestinations == null) {
            this.notificationDestinations = null;
            return;
        }
        this.notificationDestinations = new ArrayList<String>(notificationDestinations);
    }

    public WorkspaceSummary withNotificationDestinations(String ... notificationDestinations) {
        if (this.notificationDestinations == null) {
            this.setNotificationDestinations(new ArrayList<String>(notificationDestinations.length));
        }
        for (String ele : notificationDestinations) {
            this.notificationDestinations.add(ele);
        }
        return this;
    }

    public WorkspaceSummary withNotificationDestinations(Collection<String> notificationDestinations) {
        this.setNotificationDestinations(notificationDestinations);
        return this;
    }

    public WorkspaceSummary withNotificationDestinations(NotificationDestinationType ... notificationDestinations) {
        ArrayList<String> notificationDestinationsCopy = new ArrayList<String>(notificationDestinations.length);
        for (NotificationDestinationType value : notificationDestinations) {
            notificationDestinationsCopy.add(value.toString());
        }
        if (this.getNotificationDestinations() == null) {
            this.setNotificationDestinations(notificationDestinationsCopy);
        } else {
            this.getNotificationDestinations().addAll(notificationDestinationsCopy);
        }
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public WorkspaceSummary withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public WorkspaceSummary withStatus(WorkspaceStatus status) {
        this.status = status.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public WorkspaceSummary withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public WorkspaceSummary addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public WorkspaceSummary clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuthentication() != null) {
            sb.append("Authentication: ").append(this.getAuthentication()).append(",");
        }
        if (this.getCreated() != null) {
            sb.append("Created: ").append(this.getCreated()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: ").append(this.getEndpoint()).append(",");
        }
        if (this.getGrafanaVersion() != null) {
            sb.append("GrafanaVersion: ").append(this.getGrafanaVersion()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getModified() != null) {
            sb.append("Modified: ").append(this.getModified()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getNotificationDestinations() != null) {
            sb.append("NotificationDestinations: ").append(this.getNotificationDestinations()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceSummary)) {
            return false;
        }
        WorkspaceSummary other = (WorkspaceSummary)obj;
        if (other.getAuthentication() == null ^ this.getAuthentication() == null) {
            return false;
        }
        if (other.getAuthentication() != null && !other.getAuthentication().equals(this.getAuthentication())) {
            return false;
        }
        if (other.getCreated() == null ^ this.getCreated() == null) {
            return false;
        }
        if (other.getCreated() != null && !other.getCreated().equals(this.getCreated())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getGrafanaVersion() == null ^ this.getGrafanaVersion() == null) {
            return false;
        }
        if (other.getGrafanaVersion() != null && !other.getGrafanaVersion().equals(this.getGrafanaVersion())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getModified() == null ^ this.getModified() == null) {
            return false;
        }
        if (other.getModified() != null && !other.getModified().equals(this.getModified())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getNotificationDestinations() == null ^ this.getNotificationDestinations() == null) {
            return false;
        }
        if (other.getNotificationDestinations() != null && !other.getNotificationDestinations().equals(this.getNotificationDestinations())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuthentication() == null ? 0 : this.getAuthentication().hashCode());
        hashCode = 31 * hashCode + (this.getCreated() == null ? 0 : this.getCreated().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getGrafanaVersion() == null ? 0 : this.getGrafanaVersion().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getModified() == null ? 0 : this.getModified().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getNotificationDestinations() == null ? 0 : this.getNotificationDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public WorkspaceSummary clone() {
        try {
            return (WorkspaceSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkspaceSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

