/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mailmanager.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * An archive resource for storing and retaining emails.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/Archive" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Archive implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The unique identifier of the archive.
     * </p>
     */
    private String archiveId;
    /**
     * <p>
     * The unique name assigned to the archive.
     * </p>
     */
    private String archiveName;
    /**
     * <p>
     * The current state of the archive:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – The archive is ready and available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted in 30
     * days. No further modifications can be made in this state.
     * </p>
     * </li>
     * </ul>
     */
    private String archiveState;
    /**
     * <p>
     * The timestamp of when the archive was last updated.
     * </p>
     */
    private java.util.Date lastUpdatedTimestamp;

    /**
     * <p>
     * The unique identifier of the archive.
     * </p>
     * 
     * @param archiveId
     *        The unique identifier of the archive.
     */

    public void setArchiveId(String archiveId) {
        this.archiveId = archiveId;
    }

    /**
     * <p>
     * The unique identifier of the archive.
     * </p>
     * 
     * @return The unique identifier of the archive.
     */

    public String getArchiveId() {
        return this.archiveId;
    }

    /**
     * <p>
     * The unique identifier of the archive.
     * </p>
     * 
     * @param archiveId
     *        The unique identifier of the archive.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Archive withArchiveId(String archiveId) {
        setArchiveId(archiveId);
        return this;
    }

    /**
     * <p>
     * The unique name assigned to the archive.
     * </p>
     * 
     * @param archiveName
     *        The unique name assigned to the archive.
     */

    public void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    /**
     * <p>
     * The unique name assigned to the archive.
     * </p>
     * 
     * @return The unique name assigned to the archive.
     */

    public String getArchiveName() {
        return this.archiveName;
    }

    /**
     * <p>
     * The unique name assigned to the archive.
     * </p>
     * 
     * @param archiveName
     *        The unique name assigned to the archive.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Archive withArchiveName(String archiveName) {
        setArchiveName(archiveName);
        return this;
    }

    /**
     * <p>
     * The current state of the archive:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – The archive is ready and available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted in 30
     * days. No further modifications can be made in this state.
     * </p>
     * </li>
     * </ul>
     * 
     * @param archiveState
     *        The current state of the archive:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>ACTIVE</code> – The archive is ready and available for use.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted
     *        in 30 days. No further modifications can be made in this state.
     *        </p>
     *        </li>
     * @see ArchiveState
     */

    public void setArchiveState(String archiveState) {
        this.archiveState = archiveState;
    }

    /**
     * <p>
     * The current state of the archive:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – The archive is ready and available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted in 30
     * days. No further modifications can be made in this state.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current state of the archive:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> – The archive is ready and available for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted
     *         in 30 days. No further modifications can be made in this state.
     *         </p>
     *         </li>
     * @see ArchiveState
     */

    public String getArchiveState() {
        return this.archiveState;
    }

    /**
     * <p>
     * The current state of the archive:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – The archive is ready and available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted in 30
     * days. No further modifications can be made in this state.
     * </p>
     * </li>
     * </ul>
     * 
     * @param archiveState
     *        The current state of the archive:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>ACTIVE</code> – The archive is ready and available for use.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted
     *        in 30 days. No further modifications can be made in this state.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ArchiveState
     */

    public Archive withArchiveState(String archiveState) {
        setArchiveState(archiveState);
        return this;
    }

    /**
     * <p>
     * The current state of the archive:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – The archive is ready and available for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted in 30
     * days. No further modifications can be made in this state.
     * </p>
     * </li>
     * </ul>
     * 
     * @param archiveState
     *        The current state of the archive:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>ACTIVE</code> – The archive is ready and available for use.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>PENDING_DELETION</code> – The archive has been marked for deletion and will be permanently deleted
     *        in 30 days. No further modifications can be made in this state.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ArchiveState
     */

    public Archive withArchiveState(ArchiveState archiveState) {
        this.archiveState = archiveState.toString();
        return this;
    }

    /**
     * <p>
     * The timestamp of when the archive was last updated.
     * </p>
     * 
     * @param lastUpdatedTimestamp
     *        The timestamp of when the archive was last updated.
     */

    public void setLastUpdatedTimestamp(java.util.Date lastUpdatedTimestamp) {
        this.lastUpdatedTimestamp = lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The timestamp of when the archive was last updated.
     * </p>
     * 
     * @return The timestamp of when the archive was last updated.
     */

    public java.util.Date getLastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    /**
     * <p>
     * The timestamp of when the archive was last updated.
     * </p>
     * 
     * @param lastUpdatedTimestamp
     *        The timestamp of when the archive was last updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Archive withLastUpdatedTimestamp(java.util.Date lastUpdatedTimestamp) {
        setLastUpdatedTimestamp(lastUpdatedTimestamp);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getArchiveId() != null)
            sb.append("ArchiveId: ").append(getArchiveId()).append(",");
        if (getArchiveName() != null)
            sb.append("ArchiveName: ").append(getArchiveName()).append(",");
        if (getArchiveState() != null)
            sb.append("ArchiveState: ").append(getArchiveState()).append(",");
        if (getLastUpdatedTimestamp() != null)
            sb.append("LastUpdatedTimestamp: ").append(getLastUpdatedTimestamp());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Archive == false)
            return false;
        Archive other = (Archive) obj;
        if (other.getArchiveId() == null ^ this.getArchiveId() == null)
            return false;
        if (other.getArchiveId() != null && other.getArchiveId().equals(this.getArchiveId()) == false)
            return false;
        if (other.getArchiveName() == null ^ this.getArchiveName() == null)
            return false;
        if (other.getArchiveName() != null && other.getArchiveName().equals(this.getArchiveName()) == false)
            return false;
        if (other.getArchiveState() == null ^ this.getArchiveState() == null)
            return false;
        if (other.getArchiveState() != null && other.getArchiveState().equals(this.getArchiveState()) == false)
            return false;
        if (other.getLastUpdatedTimestamp() == null ^ this.getLastUpdatedTimestamp() == null)
            return false;
        if (other.getLastUpdatedTimestamp() != null && other.getLastUpdatedTimestamp().equals(this.getLastUpdatedTimestamp()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getArchiveId() == null) ? 0 : getArchiveId().hashCode());
        hashCode = prime * hashCode + ((getArchiveName() == null) ? 0 : getArchiveName().hashCode());
        hashCode = prime * hashCode + ((getArchiveState() == null) ? 0 : getArchiveState().hashCode());
        hashCode = prime * hashCode + ((getLastUpdatedTimestamp() == null) ? 0 : getLastUpdatedTimestamp().hashCode());
        return hashCode;
    }

    @Override
    public Archive clone() {
        try {
            return (Archive) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.mailmanager.model.transform.ArchiveMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
