/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mailmanager.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The structure for a boolean condition matching on the incoming mail.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/IngressBooleanExpression"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class IngressBooleanExpression implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The operand on which to perform a boolean condition operation.
     * </p>
     */
    private IngressBooleanToEvaluate evaluate;
    /**
     * <p>
     * The matching operator for a boolean condition expression.
     * </p>
     */
    private String operator;

    /**
     * <p>
     * The operand on which to perform a boolean condition operation.
     * </p>
     * 
     * @param evaluate
     *        The operand on which to perform a boolean condition operation.
     */

    public void setEvaluate(IngressBooleanToEvaluate evaluate) {
        this.evaluate = evaluate;
    }

    /**
     * <p>
     * The operand on which to perform a boolean condition operation.
     * </p>
     * 
     * @return The operand on which to perform a boolean condition operation.
     */

    public IngressBooleanToEvaluate getEvaluate() {
        return this.evaluate;
    }

    /**
     * <p>
     * The operand on which to perform a boolean condition operation.
     * </p>
     * 
     * @param evaluate
     *        The operand on which to perform a boolean condition operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public IngressBooleanExpression withEvaluate(IngressBooleanToEvaluate evaluate) {
        setEvaluate(evaluate);
        return this;
    }

    /**
     * <p>
     * The matching operator for a boolean condition expression.
     * </p>
     * 
     * @param operator
     *        The matching operator for a boolean condition expression.
     * @see IngressBooleanOperator
     */

    public void setOperator(String operator) {
        this.operator = operator;
    }

    /**
     * <p>
     * The matching operator for a boolean condition expression.
     * </p>
     * 
     * @return The matching operator for a boolean condition expression.
     * @see IngressBooleanOperator
     */

    public String getOperator() {
        return this.operator;
    }

    /**
     * <p>
     * The matching operator for a boolean condition expression.
     * </p>
     * 
     * @param operator
     *        The matching operator for a boolean condition expression.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IngressBooleanOperator
     */

    public IngressBooleanExpression withOperator(String operator) {
        setOperator(operator);
        return this;
    }

    /**
     * <p>
     * The matching operator for a boolean condition expression.
     * </p>
     * 
     * @param operator
     *        The matching operator for a boolean condition expression.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see IngressBooleanOperator
     */

    public IngressBooleanExpression withOperator(IngressBooleanOperator operator) {
        this.operator = operator.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEvaluate() != null)
            sb.append("Evaluate: ").append(getEvaluate()).append(",");
        if (getOperator() != null)
            sb.append("Operator: ").append(getOperator());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof IngressBooleanExpression == false)
            return false;
        IngressBooleanExpression other = (IngressBooleanExpression) obj;
        if (other.getEvaluate() == null ^ this.getEvaluate() == null)
            return false;
        if (other.getEvaluate() != null && other.getEvaluate().equals(this.getEvaluate()) == false)
            return false;
        if (other.getOperator() == null ^ this.getOperator() == null)
            return false;
        if (other.getOperator() != null && other.getOperator().equals(this.getOperator()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEvaluate() == null) ? 0 : getEvaluate().hashCode());
        hashCode = prime * hashCode + ((getOperator() == null) ? 0 : getOperator().hashCode());
        return hashCode;
    }

    @Override
    public IngressBooleanExpression clone() {
        try {
            return (IngressBooleanExpression) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.mailmanager.model.transform.IngressBooleanExpressionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
