/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.S3BucketCriteriaForJob;
import com.amazonaws.services.macie2.model.S3BucketDefinitionForJob;
import com.amazonaws.services.macie2.model.Scoping;
import com.amazonaws.services.macie2.model.transform.S3JobDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class S3JobDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private List<S3BucketDefinitionForJob> bucketDefinitions;
    private Scoping scoping;
    private S3BucketCriteriaForJob bucketCriteria;

    public List<S3BucketDefinitionForJob> getBucketDefinitions() {
        return this.bucketDefinitions;
    }

    public void setBucketDefinitions(Collection<S3BucketDefinitionForJob> bucketDefinitions) {
        if (bucketDefinitions == null) {
            this.bucketDefinitions = null;
            return;
        }
        this.bucketDefinitions = new ArrayList<S3BucketDefinitionForJob>(bucketDefinitions);
    }

    public S3JobDefinition withBucketDefinitions(S3BucketDefinitionForJob ... bucketDefinitions) {
        if (this.bucketDefinitions == null) {
            this.setBucketDefinitions(new ArrayList<S3BucketDefinitionForJob>(bucketDefinitions.length));
        }
        for (S3BucketDefinitionForJob ele : bucketDefinitions) {
            this.bucketDefinitions.add(ele);
        }
        return this;
    }

    public S3JobDefinition withBucketDefinitions(Collection<S3BucketDefinitionForJob> bucketDefinitions) {
        this.setBucketDefinitions(bucketDefinitions);
        return this;
    }

    public void setScoping(Scoping scoping) {
        this.scoping = scoping;
    }

    public Scoping getScoping() {
        return this.scoping;
    }

    public S3JobDefinition withScoping(Scoping scoping) {
        this.setScoping(scoping);
        return this;
    }

    public void setBucketCriteria(S3BucketCriteriaForJob bucketCriteria) {
        this.bucketCriteria = bucketCriteria;
    }

    public S3BucketCriteriaForJob getBucketCriteria() {
        return this.bucketCriteria;
    }

    public S3JobDefinition withBucketCriteria(S3BucketCriteriaForJob bucketCriteria) {
        this.setBucketCriteria(bucketCriteria);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketDefinitions() != null) {
            sb.append("BucketDefinitions: ").append(this.getBucketDefinitions()).append(",");
        }
        if (this.getScoping() != null) {
            sb.append("Scoping: ").append(this.getScoping()).append(",");
        }
        if (this.getBucketCriteria() != null) {
            sb.append("BucketCriteria: ").append(this.getBucketCriteria());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3JobDefinition)) {
            return false;
        }
        S3JobDefinition other = (S3JobDefinition)obj;
        if (other.getBucketDefinitions() == null ^ this.getBucketDefinitions() == null) {
            return false;
        }
        if (other.getBucketDefinitions() != null && !other.getBucketDefinitions().equals(this.getBucketDefinitions())) {
            return false;
        }
        if (other.getScoping() == null ^ this.getScoping() == null) {
            return false;
        }
        if (other.getScoping() != null && !other.getScoping().equals(this.getScoping())) {
            return false;
        }
        if (other.getBucketCriteria() == null ^ this.getBucketCriteria() == null) {
            return false;
        }
        return other.getBucketCriteria() == null || other.getBucketCriteria().equals(this.getBucketCriteria());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketDefinitions() == null ? 0 : this.getBucketDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getScoping() == null ? 0 : this.getScoping().hashCode());
        hashCode = 31 * hashCode + (this.getBucketCriteria() == null ? 0 : this.getBucketCriteria().hashCode());
        return hashCode;
    }

    public S3JobDefinition clone() {
        try {
            return (S3JobDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3JobDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

