/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.machinelearning.model.MLModel;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class MLModelMarshaller {
    private static final MarshallingInfo<String> MLMODELID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelId").build();
    private static final MarshallingInfo<String> TRAININGDATASOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingDataSourceId").build();
    private static final MarshallingInfo<String> CREATEDBYIAMUSER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedByIamUser").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Long> SIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeInBytes").build();
    private static final MarshallingInfo<StructuredPojo> ENDPOINTINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndpointInfo").build();
    private static final MarshallingInfo<Map> TRAININGPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingParameters").build();
    private static final MarshallingInfo<String> INPUTDATALOCATIONS3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputDataLocationS3").build();
    private static final MarshallingInfo<String> ALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Algorithm").build();
    private static final MarshallingInfo<String> MLMODELTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MLModelType").build();
    private static final MarshallingInfo<Float> SCORETHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScoreThreshold").build();
    private static final MarshallingInfo<Date> SCORETHRESHOLDLASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScoreThresholdLastUpdatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Message").build();
    private static final MarshallingInfo<Long> COMPUTETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComputeTime").build();
    private static final MarshallingInfo<Date> FINISHEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FinishedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> STARTEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedAt").timestampFormat("unixTimestamp").build();
    private static final MLModelMarshaller instance = new MLModelMarshaller();

    public static MLModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(MLModel mLModel, ProtocolMarshaller protocolMarshaller) {
        if (mLModel == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mLModel.getMLModelId(), MLMODELID_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getTrainingDataSourceId(), TRAININGDATASOURCEID_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getCreatedByIamUser(), CREATEDBYIAMUSER_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getLastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getSizeInBytes(), SIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getEndpointInfo(), ENDPOINTINFO_BINDING);
            protocolMarshaller.marshall(mLModel.getTrainingParameters(), TRAININGPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getInputDataLocationS3(), INPUTDATALOCATIONS3_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getAlgorithm(), ALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getMLModelType(), MLMODELTYPE_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getScoreThreshold(), SCORETHRESHOLD_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getScoreThresholdLastUpdatedAt(), SCORETHRESHOLDLASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getMessage(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getComputeTime(), COMPUTETIME_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getFinishedAt(), FINISHEDAT_BINDING);
            protocolMarshaller.marshall((Object)mLModel.getStartedAt(), STARTEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

