/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.machinelearning.model.CreateDataSourceFromRDSRequest;
import com.amazonaws.services.machinelearning.model.RDSDataSpec;
import com.amazonaws.services.machinelearning.model.RDSDatabase;
import com.amazonaws.services.machinelearning.model.RDSDatabaseCredentials;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateDataSourceFromRDSRequestMarshaller
implements Marshaller<Request<CreateDataSourceFromRDSRequest>, CreateDataSourceFromRDSRequest> {
    public Request<CreateDataSourceFromRDSRequest> marshall(CreateDataSourceFromRDSRequest createDataSourceFromRDSRequest) {
        if (createDataSourceFromRDSRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDataSourceFromRDSRequest, "AmazonMachineLearning");
        String target = "AmazonML_20141212.CreateDataSourceFromRDS";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            RDSDataSpec rDSData;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createDataSourceFromRDSRequest.getDataSourceId() != null) {
                jsonWriter.key("DataSourceId").value((Object)createDataSourceFromRDSRequest.getDataSourceId());
            }
            if (createDataSourceFromRDSRequest.getDataSourceName() != null) {
                jsonWriter.key("DataSourceName").value((Object)createDataSourceFromRDSRequest.getDataSourceName());
            }
            if ((rDSData = createDataSourceFromRDSRequest.getRDSData()) != null) {
                ListWithAutoConstructFlag securityGroupIdsList;
                RDSDatabaseCredentials databaseCredentials;
                jsonWriter.key("RDSData");
                jsonWriter.object();
                RDSDatabase databaseInformation = rDSData.getDatabaseInformation();
                if (databaseInformation != null) {
                    jsonWriter.key("DatabaseInformation");
                    jsonWriter.object();
                    if (databaseInformation.getInstanceIdentifier() != null) {
                        jsonWriter.key("InstanceIdentifier").value((Object)databaseInformation.getInstanceIdentifier());
                    }
                    if (databaseInformation.getDatabaseName() != null) {
                        jsonWriter.key("DatabaseName").value((Object)databaseInformation.getDatabaseName());
                    }
                    jsonWriter.endObject();
                }
                if (rDSData.getSelectSqlQuery() != null) {
                    jsonWriter.key("SelectSqlQuery").value((Object)rDSData.getSelectSqlQuery());
                }
                if ((databaseCredentials = rDSData.getDatabaseCredentials()) != null) {
                    jsonWriter.key("DatabaseCredentials");
                    jsonWriter.object();
                    if (databaseCredentials.getUsername() != null) {
                        jsonWriter.key("Username").value((Object)databaseCredentials.getUsername());
                    }
                    if (databaseCredentials.getPassword() != null) {
                        jsonWriter.key("Password").value((Object)databaseCredentials.getPassword());
                    }
                    jsonWriter.endObject();
                }
                if (rDSData.getS3StagingLocation() != null) {
                    jsonWriter.key("S3StagingLocation").value((Object)rDSData.getS3StagingLocation());
                }
                if (rDSData.getDataRearrangement() != null) {
                    jsonWriter.key("DataRearrangement").value((Object)rDSData.getDataRearrangement());
                }
                if (rDSData.getDataSchema() != null) {
                    jsonWriter.key("DataSchema").value((Object)rDSData.getDataSchema());
                }
                if (rDSData.getDataSchemaUri() != null) {
                    jsonWriter.key("DataSchemaUri").value((Object)rDSData.getDataSchemaUri());
                }
                if (rDSData.getResourceRole() != null) {
                    jsonWriter.key("ResourceRole").value((Object)rDSData.getResourceRole());
                }
                if (rDSData.getServiceRole() != null) {
                    jsonWriter.key("ServiceRole").value((Object)rDSData.getServiceRole());
                }
                if (rDSData.getSubnetId() != null) {
                    jsonWriter.key("SubnetId").value((Object)rDSData.getSubnetId());
                }
                if (!((securityGroupIdsList = (ListWithAutoConstructFlag)rDSData.getSecurityGroupIds()) == null || securityGroupIdsList.isAutoConstruct() && securityGroupIdsList.isEmpty())) {
                    jsonWriter.key("SecurityGroupIds");
                    jsonWriter.array();
                    for (String securityGroupIdsListValue : securityGroupIdsList) {
                        if (securityGroupIdsListValue == null) continue;
                        jsonWriter.value((Object)securityGroupIdsListValue);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if (createDataSourceFromRDSRequest.getRoleARN() != null) {
                jsonWriter.key("RoleARN").value((Object)createDataSourceFromRDSRequest.getRoleARN());
            }
            if (createDataSourceFromRDSRequest.isComputeStatistics() != null) {
                jsonWriter.key("ComputeStatistics").value((Object)createDataSourceFromRDSRequest.isComputeStatistics());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

