/*
 * Copyright 2010-2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.machinelearning.model;

import java.io.Serializable;

/**
 * <p>
 * The database credentials to connect to a database on an RDS DB instance.
 * </p>
 */
public class RDSDatabaseCredentials implements Serializable, Cloneable {

    private String username;

    private String password;

    /**
     * Sets the value of the Username property for this object.
     * 
     * @param username
     *        The new value for the Username property for this object.
     */
    public void setUsername(String username) {
        this.username = username;
    }

    /**
     * Returns the value of the Username property for this object.
     * 
     * @return The value of the Username property for this object.
     */
    public String getUsername() {
        return this.username;
    }

    /**
     * Sets the value of the Username property for this object.
     * 
     * @param username
     *        The new value for the Username property for this object.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public RDSDatabaseCredentials withUsername(String username) {
        setUsername(username);
        return this;
    }

    /**
     * Sets the value of the Password property for this object.
     * 
     * @param password
     *        The new value for the Password property for this object.
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * Returns the value of the Password property for this object.
     * 
     * @return The value of the Password property for this object.
     */
    public String getPassword() {
        return this.password;
    }

    /**
     * Sets the value of the Password property for this object.
     * 
     * @param password
     *        The new value for the Password property for this object.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */
    public RDSDatabaseCredentials withPassword(String password) {
        setPassword(password);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getUsername() != null)
            sb.append("Username: " + getUsername() + ",");
        if (getPassword() != null)
            sb.append("Password: " + getPassword());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RDSDatabaseCredentials == false)
            return false;
        RDSDatabaseCredentials other = (RDSDatabaseCredentials) obj;
        if (other.getUsername() == null ^ this.getUsername() == null)
            return false;
        if (other.getUsername() != null
                && other.getUsername().equals(this.getUsername()) == false)
            return false;
        if (other.getPassword() == null ^ this.getPassword() == null)
            return false;
        if (other.getPassword() != null
                && other.getPassword().equals(this.getPassword()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode
                + ((getUsername() == null) ? 0 : getUsername().hashCode());
        hashCode = prime * hashCode
                + ((getPassword() == null) ? 0 : getPassword().hashCode());
        return hashCode;
    }

    @Override
    public RDSDatabaseCredentials clone() {
        try {
            return (RDSDatabaseCredentials) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException(
                    "Got a CloneNotSupportedException from Object.clone() "
                            + "even though we're Cloneable!", e);
        }
    }
}