/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutmetrics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutmetrics.model.transform.AutoDetectionS3SourceConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AutoDetectionS3SourceConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> templatedPathList;
    private List<String> historicalDataPathList;

    public List<String> getTemplatedPathList() {
        return this.templatedPathList;
    }

    public void setTemplatedPathList(Collection<String> templatedPathList) {
        if (templatedPathList == null) {
            this.templatedPathList = null;
            return;
        }
        this.templatedPathList = new ArrayList<String>(templatedPathList);
    }

    public AutoDetectionS3SourceConfig withTemplatedPathList(String ... templatedPathList) {
        if (this.templatedPathList == null) {
            this.setTemplatedPathList(new ArrayList<String>(templatedPathList.length));
        }
        for (String ele : templatedPathList) {
            this.templatedPathList.add(ele);
        }
        return this;
    }

    public AutoDetectionS3SourceConfig withTemplatedPathList(Collection<String> templatedPathList) {
        this.setTemplatedPathList(templatedPathList);
        return this;
    }

    public List<String> getHistoricalDataPathList() {
        return this.historicalDataPathList;
    }

    public void setHistoricalDataPathList(Collection<String> historicalDataPathList) {
        if (historicalDataPathList == null) {
            this.historicalDataPathList = null;
            return;
        }
        this.historicalDataPathList = new ArrayList<String>(historicalDataPathList);
    }

    public AutoDetectionS3SourceConfig withHistoricalDataPathList(String ... historicalDataPathList) {
        if (this.historicalDataPathList == null) {
            this.setHistoricalDataPathList(new ArrayList<String>(historicalDataPathList.length));
        }
        for (String ele : historicalDataPathList) {
            this.historicalDataPathList.add(ele);
        }
        return this;
    }

    public AutoDetectionS3SourceConfig withHistoricalDataPathList(Collection<String> historicalDataPathList) {
        this.setHistoricalDataPathList(historicalDataPathList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTemplatedPathList() != null) {
            sb.append("TemplatedPathList: ").append(this.getTemplatedPathList()).append(",");
        }
        if (this.getHistoricalDataPathList() != null) {
            sb.append("HistoricalDataPathList: ").append(this.getHistoricalDataPathList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoDetectionS3SourceConfig)) {
            return false;
        }
        AutoDetectionS3SourceConfig other = (AutoDetectionS3SourceConfig)obj;
        if (other.getTemplatedPathList() == null ^ this.getTemplatedPathList() == null) {
            return false;
        }
        if (other.getTemplatedPathList() != null && !other.getTemplatedPathList().equals(this.getTemplatedPathList())) {
            return false;
        }
        if (other.getHistoricalDataPathList() == null ^ this.getHistoricalDataPathList() == null) {
            return false;
        }
        return other.getHistoricalDataPathList() == null || other.getHistoricalDataPathList().equals(this.getHistoricalDataPathList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTemplatedPathList() == null ? 0 : this.getTemplatedPathList().hashCode());
        hashCode = 31 * hashCode + (this.getHistoricalDataPathList() == null ? 0 : this.getHistoricalDataPathList().hashCode());
        return hashCode;
    }

    public AutoDetectionS3SourceConfig clone() {
        try {
            return (AutoDetectionS3SourceConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoDetectionS3SourceConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

