/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.location.model.DevicePosition;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DevicePositionMarshaller {
    private static final MarshallingInfo<String> DEVICEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceId").build();
    private static final MarshallingInfo<List> POSITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Position").build();
    private static final MarshallingInfo<Date> RECEIVEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReceivedTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> SAMPLETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SampleTime").timestampFormat("iso8601").build();
    private static final DevicePositionMarshaller instance = new DevicePositionMarshaller();

    public static DevicePositionMarshaller getInstance() {
        return instance;
    }

    public void marshall(DevicePosition devicePosition, ProtocolMarshaller protocolMarshaller) {
        if (devicePosition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)devicePosition.getDeviceId(), DEVICEID_BINDING);
            protocolMarshaller.marshall(devicePosition.getPosition(), POSITION_BINDING);
            protocolMarshaller.marshall((Object)devicePosition.getReceivedTime(), RECEIVEDTIME_BINDING);
            protocolMarshaller.marshall((Object)devicePosition.getSampleTime(), SAMPLETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

