/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lightsail.model.ContainerServicePowerName;
import com.amazonaws.services.lightsail.model.PrivateRegistryAccessRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateContainerServiceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String serviceName;
    private String power;
    private Integer scale;
    private Boolean isDisabled;
    private Map<String, List<String>> publicDomainNames;
    private PrivateRegistryAccessRequest privateRegistryAccess;

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public UpdateContainerServiceRequest withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public void setPower(String power) {
        this.power = power;
    }

    public String getPower() {
        return this.power;
    }

    public UpdateContainerServiceRequest withPower(String power) {
        this.setPower(power);
        return this;
    }

    public UpdateContainerServiceRequest withPower(ContainerServicePowerName power) {
        this.power = power.toString();
        return this;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public Integer getScale() {
        return this.scale;
    }

    public UpdateContainerServiceRequest withScale(Integer scale) {
        this.setScale(scale);
        return this;
    }

    public void setIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public Boolean getIsDisabled() {
        return this.isDisabled;
    }

    public UpdateContainerServiceRequest withIsDisabled(Boolean isDisabled) {
        this.setIsDisabled(isDisabled);
        return this;
    }

    public Boolean isDisabled() {
        return this.isDisabled;
    }

    public Map<String, List<String>> getPublicDomainNames() {
        return this.publicDomainNames;
    }

    public void setPublicDomainNames(Map<String, List<String>> publicDomainNames) {
        this.publicDomainNames = publicDomainNames;
    }

    public UpdateContainerServiceRequest withPublicDomainNames(Map<String, List<String>> publicDomainNames) {
        this.setPublicDomainNames(publicDomainNames);
        return this;
    }

    public UpdateContainerServiceRequest addPublicDomainNamesEntry(String key, List<String> value) {
        if (null == this.publicDomainNames) {
            this.publicDomainNames = new HashMap<String, List<String>>();
        }
        if (this.publicDomainNames.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.publicDomainNames.put(key, value);
        return this;
    }

    public UpdateContainerServiceRequest clearPublicDomainNamesEntries() {
        this.publicDomainNames = null;
        return this;
    }

    public void setPrivateRegistryAccess(PrivateRegistryAccessRequest privateRegistryAccess) {
        this.privateRegistryAccess = privateRegistryAccess;
    }

    public PrivateRegistryAccessRequest getPrivateRegistryAccess() {
        return this.privateRegistryAccess;
    }

    public UpdateContainerServiceRequest withPrivateRegistryAccess(PrivateRegistryAccessRequest privateRegistryAccess) {
        this.setPrivateRegistryAccess(privateRegistryAccess);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceName() != null) {
            sb.append("ServiceName: ").append(this.getServiceName()).append(",");
        }
        if (this.getPower() != null) {
            sb.append("Power: ").append(this.getPower()).append(",");
        }
        if (this.getScale() != null) {
            sb.append("Scale: ").append(this.getScale()).append(",");
        }
        if (this.getIsDisabled() != null) {
            sb.append("IsDisabled: ").append(this.getIsDisabled()).append(",");
        }
        if (this.getPublicDomainNames() != null) {
            sb.append("PublicDomainNames: ").append(this.getPublicDomainNames()).append(",");
        }
        if (this.getPrivateRegistryAccess() != null) {
            sb.append("PrivateRegistryAccess: ").append(this.getPrivateRegistryAccess());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContainerServiceRequest)) {
            return false;
        }
        UpdateContainerServiceRequest other = (UpdateContainerServiceRequest)obj;
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getPower() == null ^ this.getPower() == null) {
            return false;
        }
        if (other.getPower() != null && !other.getPower().equals(this.getPower())) {
            return false;
        }
        if (other.getScale() == null ^ this.getScale() == null) {
            return false;
        }
        if (other.getScale() != null && !other.getScale().equals(this.getScale())) {
            return false;
        }
        if (other.getIsDisabled() == null ^ this.getIsDisabled() == null) {
            return false;
        }
        if (other.getIsDisabled() != null && !other.getIsDisabled().equals(this.getIsDisabled())) {
            return false;
        }
        if (other.getPublicDomainNames() == null ^ this.getPublicDomainNames() == null) {
            return false;
        }
        if (other.getPublicDomainNames() != null && !other.getPublicDomainNames().equals(this.getPublicDomainNames())) {
            return false;
        }
        if (other.getPrivateRegistryAccess() == null ^ this.getPrivateRegistryAccess() == null) {
            return false;
        }
        return other.getPrivateRegistryAccess() == null || other.getPrivateRegistryAccess().equals(this.getPrivateRegistryAccess());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getPower() == null ? 0 : this.getPower().hashCode());
        hashCode = 31 * hashCode + (this.getScale() == null ? 0 : this.getScale().hashCode());
        hashCode = 31 * hashCode + (this.getIsDisabled() == null ? 0 : this.getIsDisabled().hashCode());
        hashCode = 31 * hashCode + (this.getPublicDomainNames() == null ? 0 : this.getPublicDomainNames().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateRegistryAccess() == null ? 0 : this.getPrivateRegistryAccess().hashCode());
        return hashCode;
    }

    public UpdateContainerServiceRequest clone() {
        return (UpdateContainerServiceRequest)super.clone();
    }
}

