/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.AccessRules;
import com.amazonaws.services.lightsail.model.BucketState;
import com.amazonaws.services.lightsail.model.ResourceLocation;
import com.amazonaws.services.lightsail.model.ResourceReceivingAccess;
import com.amazonaws.services.lightsail.model.Tag;
import com.amazonaws.services.lightsail.model.transform.BucketMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Bucket
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceType;
    private AccessRules accessRules;
    private String arn;
    private String bundleId;
    private Date createdAt;
    private String url;
    private ResourceLocation location;
    private String name;
    private String supportCode;
    private List<Tag> tags;
    private String objectVersioning;
    private Boolean ableToUpdateBundle;
    private List<String> readonlyAccessAccounts;
    private List<ResourceReceivingAccess> resourcesReceivingAccess;
    private BucketState state;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public Bucket withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setAccessRules(AccessRules accessRules) {
        this.accessRules = accessRules;
    }

    public AccessRules getAccessRules() {
        return this.accessRules;
    }

    public Bucket withAccessRules(AccessRules accessRules) {
        this.setAccessRules(accessRules);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Bucket withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public Bucket withBundleId(String bundleId) {
        this.setBundleId(bundleId);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Bucket withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public Bucket withUrl(String url) {
        this.setUrl(url);
        return this;
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public Bucket withLocation(ResourceLocation location) {
        this.setLocation(location);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Bucket withName(String name) {
        this.setName(name);
        return this;
    }

    public void setSupportCode(String supportCode) {
        this.supportCode = supportCode;
    }

    public String getSupportCode() {
        return this.supportCode;
    }

    public Bucket withSupportCode(String supportCode) {
        this.setSupportCode(supportCode);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public Bucket withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Bucket withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setObjectVersioning(String objectVersioning) {
        this.objectVersioning = objectVersioning;
    }

    public String getObjectVersioning() {
        return this.objectVersioning;
    }

    public Bucket withObjectVersioning(String objectVersioning) {
        this.setObjectVersioning(objectVersioning);
        return this;
    }

    public void setAbleToUpdateBundle(Boolean ableToUpdateBundle) {
        this.ableToUpdateBundle = ableToUpdateBundle;
    }

    public Boolean getAbleToUpdateBundle() {
        return this.ableToUpdateBundle;
    }

    public Bucket withAbleToUpdateBundle(Boolean ableToUpdateBundle) {
        this.setAbleToUpdateBundle(ableToUpdateBundle);
        return this;
    }

    public Boolean isAbleToUpdateBundle() {
        return this.ableToUpdateBundle;
    }

    public List<String> getReadonlyAccessAccounts() {
        return this.readonlyAccessAccounts;
    }

    public void setReadonlyAccessAccounts(Collection<String> readonlyAccessAccounts) {
        if (readonlyAccessAccounts == null) {
            this.readonlyAccessAccounts = null;
            return;
        }
        this.readonlyAccessAccounts = new ArrayList<String>(readonlyAccessAccounts);
    }

    public Bucket withReadonlyAccessAccounts(String ... readonlyAccessAccounts) {
        if (this.readonlyAccessAccounts == null) {
            this.setReadonlyAccessAccounts(new ArrayList<String>(readonlyAccessAccounts.length));
        }
        for (String ele : readonlyAccessAccounts) {
            this.readonlyAccessAccounts.add(ele);
        }
        return this;
    }

    public Bucket withReadonlyAccessAccounts(Collection<String> readonlyAccessAccounts) {
        this.setReadonlyAccessAccounts(readonlyAccessAccounts);
        return this;
    }

    public List<ResourceReceivingAccess> getResourcesReceivingAccess() {
        return this.resourcesReceivingAccess;
    }

    public void setResourcesReceivingAccess(Collection<ResourceReceivingAccess> resourcesReceivingAccess) {
        if (resourcesReceivingAccess == null) {
            this.resourcesReceivingAccess = null;
            return;
        }
        this.resourcesReceivingAccess = new ArrayList<ResourceReceivingAccess>(resourcesReceivingAccess);
    }

    public Bucket withResourcesReceivingAccess(ResourceReceivingAccess ... resourcesReceivingAccess) {
        if (this.resourcesReceivingAccess == null) {
            this.setResourcesReceivingAccess(new ArrayList<ResourceReceivingAccess>(resourcesReceivingAccess.length));
        }
        for (ResourceReceivingAccess ele : resourcesReceivingAccess) {
            this.resourcesReceivingAccess.add(ele);
        }
        return this;
    }

    public Bucket withResourcesReceivingAccess(Collection<ResourceReceivingAccess> resourcesReceivingAccess) {
        this.setResourcesReceivingAccess(resourcesReceivingAccess);
        return this;
    }

    public void setState(BucketState state) {
        this.state = state;
    }

    public BucketState getState() {
        return this.state;
    }

    public Bucket withState(BucketState state) {
        this.setState(state);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getAccessRules() != null) {
            sb.append("AccessRules: ").append(this.getAccessRules()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getBundleId() != null) {
            sb.append("BundleId: ").append(this.getBundleId()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getUrl() != null) {
            sb.append("Url: ").append(this.getUrl()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getSupportCode() != null) {
            sb.append("SupportCode: ").append(this.getSupportCode()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getObjectVersioning() != null) {
            sb.append("ObjectVersioning: ").append(this.getObjectVersioning()).append(",");
        }
        if (this.getAbleToUpdateBundle() != null) {
            sb.append("AbleToUpdateBundle: ").append(this.getAbleToUpdateBundle()).append(",");
        }
        if (this.getReadonlyAccessAccounts() != null) {
            sb.append("ReadonlyAccessAccounts: ").append(this.getReadonlyAccessAccounts()).append(",");
        }
        if (this.getResourcesReceivingAccess() != null) {
            sb.append("ResourcesReceivingAccess: ").append(this.getResourcesReceivingAccess()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bucket)) {
            return false;
        }
        Bucket other = (Bucket)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getAccessRules() == null ^ this.getAccessRules() == null) {
            return false;
        }
        if (other.getAccessRules() != null && !other.getAccessRules().equals(this.getAccessRules())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getBundleId() == null ^ this.getBundleId() == null) {
            return false;
        }
        if (other.getBundleId() != null && !other.getBundleId().equals(this.getBundleId())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getUrl() == null ^ this.getUrl() == null) {
            return false;
        }
        if (other.getUrl() != null && !other.getUrl().equals(this.getUrl())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getSupportCode() == null ^ this.getSupportCode() == null) {
            return false;
        }
        if (other.getSupportCode() != null && !other.getSupportCode().equals(this.getSupportCode())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getObjectVersioning() == null ^ this.getObjectVersioning() == null) {
            return false;
        }
        if (other.getObjectVersioning() != null && !other.getObjectVersioning().equals(this.getObjectVersioning())) {
            return false;
        }
        if (other.getAbleToUpdateBundle() == null ^ this.getAbleToUpdateBundle() == null) {
            return false;
        }
        if (other.getAbleToUpdateBundle() != null && !other.getAbleToUpdateBundle().equals(this.getAbleToUpdateBundle())) {
            return false;
        }
        if (other.getReadonlyAccessAccounts() == null ^ this.getReadonlyAccessAccounts() == null) {
            return false;
        }
        if (other.getReadonlyAccessAccounts() != null && !other.getReadonlyAccessAccounts().equals(this.getReadonlyAccessAccounts())) {
            return false;
        }
        if (other.getResourcesReceivingAccess() == null ^ this.getResourcesReceivingAccess() == null) {
            return false;
        }
        if (other.getResourcesReceivingAccess() != null && !other.getResourcesReceivingAccess().equals(this.getResourcesReceivingAccess())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        return other.getState() == null || other.getState().equals(this.getState());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getAccessRules() == null ? 0 : this.getAccessRules().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getBundleId() == null ? 0 : this.getBundleId().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getUrl() == null ? 0 : this.getUrl().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getSupportCode() == null ? 0 : this.getSupportCode().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getObjectVersioning() == null ? 0 : this.getObjectVersioning().hashCode());
        hashCode = 31 * hashCode + (this.getAbleToUpdateBundle() == null ? 0 : this.getAbleToUpdateBundle().hashCode());
        hashCode = 31 * hashCode + (this.getReadonlyAccessAccounts() == null ? 0 : this.getReadonlyAccessAccounts().hashCode());
        hashCode = 31 * hashCode + (this.getResourcesReceivingAccess() == null ? 0 : this.getResourcesReceivingAccess().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        return hashCode;
    }

    public Bucket clone() {
        try {
            return (Bucket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BucketMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

