/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.lightsail.model.AutoSnapshotDetails;
import com.amazonaws.services.lightsail.model.ResourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetAutoSnapshotsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String resourceName;
    private String resourceType;
    private List<AutoSnapshotDetails> autoSnapshots;

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public GetAutoSnapshotsResult withResourceName(String resourceName) {
        this.setResourceName(resourceName);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public GetAutoSnapshotsResult withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public GetAutoSnapshotsResult withResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
        return this;
    }

    public List<AutoSnapshotDetails> getAutoSnapshots() {
        return this.autoSnapshots;
    }

    public void setAutoSnapshots(Collection<AutoSnapshotDetails> autoSnapshots) {
        if (autoSnapshots == null) {
            this.autoSnapshots = null;
            return;
        }
        this.autoSnapshots = new ArrayList<AutoSnapshotDetails>(autoSnapshots);
    }

    public GetAutoSnapshotsResult withAutoSnapshots(AutoSnapshotDetails ... autoSnapshots) {
        if (this.autoSnapshots == null) {
            this.setAutoSnapshots(new ArrayList<AutoSnapshotDetails>(autoSnapshots.length));
        }
        for (AutoSnapshotDetails ele : autoSnapshots) {
            this.autoSnapshots.add(ele);
        }
        return this;
    }

    public GetAutoSnapshotsResult withAutoSnapshots(Collection<AutoSnapshotDetails> autoSnapshots) {
        this.setAutoSnapshots(autoSnapshots);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceName() != null) {
            sb.append("ResourceName: ").append(this.getResourceName()).append(",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getAutoSnapshots() != null) {
            sb.append("AutoSnapshots: ").append(this.getAutoSnapshots());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutoSnapshotsResult)) {
            return false;
        }
        GetAutoSnapshotsResult other = (GetAutoSnapshotsResult)obj;
        if (other.getResourceName() == null ^ this.getResourceName() == null) {
            return false;
        }
        if (other.getResourceName() != null && !other.getResourceName().equals(this.getResourceName())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getAutoSnapshots() == null ^ this.getAutoSnapshots() == null) {
            return false;
        }
        return other.getAutoSnapshots() == null || other.getAutoSnapshots().equals(this.getAutoSnapshots());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceName() == null ? 0 : this.getResourceName().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getAutoSnapshots() == null ? 0 : this.getAutoSnapshots().hashCode());
        return hashCode;
    }

    public GetAutoSnapshotsResult clone() {
        try {
            return (GetAutoSnapshotsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

