/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lightsail.model.PortInfo;
import java.util.List;

@SdkInternalApi
public class PortInfoMarshaller {
    private static final MarshallingInfo<Integer> FROMPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromPort").build();
    private static final MarshallingInfo<Integer> TOPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("toPort").build();
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protocol").build();
    private static final MarshallingInfo<List> CIDRS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cidrs").build();
    private static final MarshallingInfo<List> IPV6CIDRS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipv6Cidrs").build();
    private static final MarshallingInfo<List> CIDRLISTALIASES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cidrListAliases").build();
    private static final PortInfoMarshaller instance = new PortInfoMarshaller();

    public static PortInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(PortInfo portInfo, ProtocolMarshaller protocolMarshaller) {
        if (portInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)portInfo.getFromPort(), FROMPORT_BINDING);
            protocolMarshaller.marshall((Object)portInfo.getToPort(), TOPORT_BINDING);
            protocolMarshaller.marshall((Object)portInfo.getProtocol(), PROTOCOL_BINDING);
            protocolMarshaller.marshall(portInfo.getCidrs(), CIDRS_BINDING);
            protocolMarshaller.marshall(portInfo.getIpv6Cidrs(), IPV6CIDRS_BINDING);
            protocolMarshaller.marshall(portInfo.getCidrListAliases(), CIDRLISTALIASES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

