/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.lightsail.model.ContainerServiceMetricName;
import com.amazonaws.services.lightsail.model.MetricStatistic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GetContainerServiceMetricDataRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String serviceName;
    private String metricName;
    private Date startTime;
    private Date endTime;
    private Integer period;
    private List<String> statistics;

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public GetContainerServiceMetricDataRequest withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public GetContainerServiceMetricDataRequest withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public GetContainerServiceMetricDataRequest withMetricName(ContainerServiceMetricName metricName) {
        this.metricName = metricName.toString();
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public GetContainerServiceMetricDataRequest withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public GetContainerServiceMetricDataRequest withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public GetContainerServiceMetricDataRequest withPeriod(Integer period) {
        this.setPeriod(period);
        return this;
    }

    public List<String> getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Collection<String> statistics) {
        if (statistics == null) {
            this.statistics = null;
            return;
        }
        this.statistics = new ArrayList<String>(statistics);
    }

    public GetContainerServiceMetricDataRequest withStatistics(String ... statistics) {
        if (this.statistics == null) {
            this.setStatistics(new ArrayList<String>(statistics.length));
        }
        for (String ele : statistics) {
            this.statistics.add(ele);
        }
        return this;
    }

    public GetContainerServiceMetricDataRequest withStatistics(Collection<String> statistics) {
        this.setStatistics(statistics);
        return this;
    }

    public GetContainerServiceMetricDataRequest withStatistics(MetricStatistic ... statistics) {
        ArrayList<String> statisticsCopy = new ArrayList<String>(statistics.length);
        for (MetricStatistic value : statistics) {
            statisticsCopy.add(value.toString());
        }
        if (this.getStatistics() == null) {
            this.setStatistics(statisticsCopy);
        } else {
            this.getStatistics().addAll(statisticsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceName() != null) {
            sb.append("ServiceName: ").append(this.getServiceName()).append(",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getPeriod() != null) {
            sb.append("Period: ").append(this.getPeriod()).append(",");
        }
        if (this.getStatistics() != null) {
            sb.append("Statistics: ").append(this.getStatistics());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContainerServiceMetricDataRequest)) {
            return false;
        }
        GetContainerServiceMetricDataRequest other = (GetContainerServiceMetricDataRequest)obj;
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getPeriod() == null ^ this.getPeriod() == null) {
            return false;
        }
        if (other.getPeriod() != null && !other.getPeriod().equals(this.getPeriod())) {
            return false;
        }
        if (other.getStatistics() == null ^ this.getStatistics() == null) {
            return false;
        }
        return other.getStatistics() == null || other.getStatistics().equals(this.getStatistics());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getPeriod() == null ? 0 : this.getPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getStatistics() == null ? 0 : this.getStatistics().hashCode());
        return hashCode;
    }

    public GetContainerServiceMetricDataRequest clone() {
        return (GetContainerServiceMetricDataRequest)super.clone();
    }
}

