/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lightsail.model.CookieObject;
import com.amazonaws.services.lightsail.model.HeaderObject;
import com.amazonaws.services.lightsail.model.QueryStringObject;
import com.amazonaws.services.lightsail.model.transform.CacheSettingsMarshaller;
import java.io.Serializable;

public class CacheSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private Long defaultTTL;
    private Long minimumTTL;
    private Long maximumTTL;
    private String allowedHTTPMethods;
    private String cachedHTTPMethods;
    private CookieObject forwardedCookies;
    private HeaderObject forwardedHeaders;
    private QueryStringObject forwardedQueryStrings;

    public void setDefaultTTL(Long defaultTTL) {
        this.defaultTTL = defaultTTL;
    }

    public Long getDefaultTTL() {
        return this.defaultTTL;
    }

    public CacheSettings withDefaultTTL(Long defaultTTL) {
        this.setDefaultTTL(defaultTTL);
        return this;
    }

    public void setMinimumTTL(Long minimumTTL) {
        this.minimumTTL = minimumTTL;
    }

    public Long getMinimumTTL() {
        return this.minimumTTL;
    }

    public CacheSettings withMinimumTTL(Long minimumTTL) {
        this.setMinimumTTL(minimumTTL);
        return this;
    }

    public void setMaximumTTL(Long maximumTTL) {
        this.maximumTTL = maximumTTL;
    }

    public Long getMaximumTTL() {
        return this.maximumTTL;
    }

    public CacheSettings withMaximumTTL(Long maximumTTL) {
        this.setMaximumTTL(maximumTTL);
        return this;
    }

    public void setAllowedHTTPMethods(String allowedHTTPMethods) {
        this.allowedHTTPMethods = allowedHTTPMethods;
    }

    public String getAllowedHTTPMethods() {
        return this.allowedHTTPMethods;
    }

    public CacheSettings withAllowedHTTPMethods(String allowedHTTPMethods) {
        this.setAllowedHTTPMethods(allowedHTTPMethods);
        return this;
    }

    public void setCachedHTTPMethods(String cachedHTTPMethods) {
        this.cachedHTTPMethods = cachedHTTPMethods;
    }

    public String getCachedHTTPMethods() {
        return this.cachedHTTPMethods;
    }

    public CacheSettings withCachedHTTPMethods(String cachedHTTPMethods) {
        this.setCachedHTTPMethods(cachedHTTPMethods);
        return this;
    }

    public void setForwardedCookies(CookieObject forwardedCookies) {
        this.forwardedCookies = forwardedCookies;
    }

    public CookieObject getForwardedCookies() {
        return this.forwardedCookies;
    }

    public CacheSettings withForwardedCookies(CookieObject forwardedCookies) {
        this.setForwardedCookies(forwardedCookies);
        return this;
    }

    public void setForwardedHeaders(HeaderObject forwardedHeaders) {
        this.forwardedHeaders = forwardedHeaders;
    }

    public HeaderObject getForwardedHeaders() {
        return this.forwardedHeaders;
    }

    public CacheSettings withForwardedHeaders(HeaderObject forwardedHeaders) {
        this.setForwardedHeaders(forwardedHeaders);
        return this;
    }

    public void setForwardedQueryStrings(QueryStringObject forwardedQueryStrings) {
        this.forwardedQueryStrings = forwardedQueryStrings;
    }

    public QueryStringObject getForwardedQueryStrings() {
        return this.forwardedQueryStrings;
    }

    public CacheSettings withForwardedQueryStrings(QueryStringObject forwardedQueryStrings) {
        this.setForwardedQueryStrings(forwardedQueryStrings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDefaultTTL() != null) {
            sb.append("DefaultTTL: ").append(this.getDefaultTTL()).append(",");
        }
        if (this.getMinimumTTL() != null) {
            sb.append("MinimumTTL: ").append(this.getMinimumTTL()).append(",");
        }
        if (this.getMaximumTTL() != null) {
            sb.append("MaximumTTL: ").append(this.getMaximumTTL()).append(",");
        }
        if (this.getAllowedHTTPMethods() != null) {
            sb.append("AllowedHTTPMethods: ").append(this.getAllowedHTTPMethods()).append(",");
        }
        if (this.getCachedHTTPMethods() != null) {
            sb.append("CachedHTTPMethods: ").append(this.getCachedHTTPMethods()).append(",");
        }
        if (this.getForwardedCookies() != null) {
            sb.append("ForwardedCookies: ").append(this.getForwardedCookies()).append(",");
        }
        if (this.getForwardedHeaders() != null) {
            sb.append("ForwardedHeaders: ").append(this.getForwardedHeaders()).append(",");
        }
        if (this.getForwardedQueryStrings() != null) {
            sb.append("ForwardedQueryStrings: ").append(this.getForwardedQueryStrings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheSettings)) {
            return false;
        }
        CacheSettings other = (CacheSettings)obj;
        if (other.getDefaultTTL() == null ^ this.getDefaultTTL() == null) {
            return false;
        }
        if (other.getDefaultTTL() != null && !other.getDefaultTTL().equals(this.getDefaultTTL())) {
            return false;
        }
        if (other.getMinimumTTL() == null ^ this.getMinimumTTL() == null) {
            return false;
        }
        if (other.getMinimumTTL() != null && !other.getMinimumTTL().equals(this.getMinimumTTL())) {
            return false;
        }
        if (other.getMaximumTTL() == null ^ this.getMaximumTTL() == null) {
            return false;
        }
        if (other.getMaximumTTL() != null && !other.getMaximumTTL().equals(this.getMaximumTTL())) {
            return false;
        }
        if (other.getAllowedHTTPMethods() == null ^ this.getAllowedHTTPMethods() == null) {
            return false;
        }
        if (other.getAllowedHTTPMethods() != null && !other.getAllowedHTTPMethods().equals(this.getAllowedHTTPMethods())) {
            return false;
        }
        if (other.getCachedHTTPMethods() == null ^ this.getCachedHTTPMethods() == null) {
            return false;
        }
        if (other.getCachedHTTPMethods() != null && !other.getCachedHTTPMethods().equals(this.getCachedHTTPMethods())) {
            return false;
        }
        if (other.getForwardedCookies() == null ^ this.getForwardedCookies() == null) {
            return false;
        }
        if (other.getForwardedCookies() != null && !other.getForwardedCookies().equals(this.getForwardedCookies())) {
            return false;
        }
        if (other.getForwardedHeaders() == null ^ this.getForwardedHeaders() == null) {
            return false;
        }
        if (other.getForwardedHeaders() != null && !other.getForwardedHeaders().equals(this.getForwardedHeaders())) {
            return false;
        }
        if (other.getForwardedQueryStrings() == null ^ this.getForwardedQueryStrings() == null) {
            return false;
        }
        return other.getForwardedQueryStrings() == null || other.getForwardedQueryStrings().equals(this.getForwardedQueryStrings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDefaultTTL() == null ? 0 : this.getDefaultTTL().hashCode());
        hashCode = 31 * hashCode + (this.getMinimumTTL() == null ? 0 : this.getMinimumTTL().hashCode());
        hashCode = 31 * hashCode + (this.getMaximumTTL() == null ? 0 : this.getMaximumTTL().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedHTTPMethods() == null ? 0 : this.getAllowedHTTPMethods().hashCode());
        hashCode = 31 * hashCode + (this.getCachedHTTPMethods() == null ? 0 : this.getCachedHTTPMethods().hashCode());
        hashCode = 31 * hashCode + (this.getForwardedCookies() == null ? 0 : this.getForwardedCookies().hashCode());
        hashCode = 31 * hashCode + (this.getForwardedHeaders() == null ? 0 : this.getForwardedHeaders().hashCode());
        hashCode = 31 * hashCode + (this.getForwardedQueryStrings() == null ? 0 : this.getForwardedQueryStrings().hashCode());
        return hashCode;
    }

    public CacheSettings clone() {
        try {
            return (CacheSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CacheSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

